/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class DoubleVectorBlock
extends AbstractVectorBlock
implements DoubleBlock {
    private final DoubleVector vector;

    DoubleVectorBlock(DoubleVector vector) {
        super(vector.getPositionCount(), vector.blockFactory());
        this.vector = vector;
    }

    @Override
    public DoubleVector asVector() {
        return this.vector;
    }

    @Override
    public double getDouble(int valueIndex) {
        return this.vector.getDouble(valueIndex);
    }

    @Override
    public int getTotalValueCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public DoubleBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoubleBlock) {
            DoubleBlock that = (DoubleBlock)obj;
            return DoubleBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return DoubleBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + this.vector + "]";
    }

    @Override
    public boolean isReleased() {
        return this.released || this.vector.isReleased();
    }

    public void close() {
        if (this.released || this.vector.isReleased()) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        this.released = true;
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

