/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class DocVector
extends AbstractVector
implements Vector {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DocVector.class);
    public static final int SHARD_SEGMENT_DOC_MAP_PER_ROW_OVERHEAD = 8;
    private final IntVector shards;
    private final IntVector segments;
    private final IntVector docs;
    private Boolean singleSegmentNonDecreasing;
    private int[] shardSegmentDocMapForwards;
    private int[] shardSegmentDocMapBackwards;
    final DocBlock block;

    public DocVector(IntVector shards, IntVector segments, IntVector docs, Boolean singleSegmentNonDecreasing) {
        super(shards.getPositionCount(), null);
        this.shards = shards;
        this.segments = segments;
        this.docs = docs;
        this.singleSegmentNonDecreasing = singleSegmentNonDecreasing;
        if (shards.getPositionCount() != segments.getPositionCount()) {
            throw new IllegalArgumentException("invalid position count [" + shards.getPositionCount() + " != " + segments.getPositionCount() + "]");
        }
        if (shards.getPositionCount() != docs.getPositionCount()) {
            throw new IllegalArgumentException("invalid position count [" + shards.getPositionCount() + " != " + docs.getPositionCount() + "]");
        }
        this.block = new DocBlock(this);
    }

    public IntVector shards() {
        return this.shards;
    }

    public IntVector segments() {
        return this.segments;
    }

    public IntVector docs() {
        return this.docs;
    }

    public boolean singleSegmentNonDecreasing() {
        if (this.singleSegmentNonDecreasing == null) {
            this.singleSegmentNonDecreasing = this.checkIfSingleSegmentNonDecreasing();
        }
        return this.singleSegmentNonDecreasing;
    }

    private boolean checkIfSingleSegmentNonDecreasing() {
        if (this.getPositionCount() < 2) {
            return true;
        }
        if (!this.shards.isConstant() || !this.segments.isConstant()) {
            return false;
        }
        int prev = this.docs.getInt(0);
        int p = 1;
        while (p < this.getPositionCount()) {
            int v;
            if (prev > (v = this.docs.getInt(p++))) {
                return false;
            }
            prev = v;
        }
        return true;
    }

    public int[] shardSegmentDocMapForwards() {
        this.buildShardSegmentDocMapIfMissing();
        return this.shardSegmentDocMapForwards;
    }

    public int[] shardSegmentDocMapBackwards() {
        this.buildShardSegmentDocMapIfMissing();
        return this.shardSegmentDocMapBackwards;
    }

    private void buildShardSegmentDocMapIfMissing() {
        if (this.shardSegmentDocMapForwards != null) {
            return;
        }
        this.shardSegmentDocMapForwards = new int[this.shards.getPositionCount()];
        final int[] forwards = this.shardSegmentDocMapForwards;
        for (int p = 0; p < forwards.length; ++p) {
            forwards[p] = p;
        }
        new IntroSorter(){
            int pivot;

            protected void setPivot(int i) {
                this.pivot = forwards[i];
            }

            protected int comparePivot(int j) {
                int cmp = Integer.compare(DocVector.this.shards.getInt(this.pivot), DocVector.this.shards.getInt(forwards[j]));
                if (cmp != 0) {
                    return cmp;
                }
                cmp = Integer.compare(DocVector.this.segments.getInt(this.pivot), DocVector.this.segments.getInt(forwards[j]));
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(DocVector.this.docs.getInt(this.pivot), DocVector.this.docs.getInt(forwards[j]));
            }

            protected void swap(int i, int j) {
                int tmp = forwards[i];
                forwards[i] = forwards[j];
                forwards[j] = tmp;
            }
        }.sort(0, forwards.length);
        this.shardSegmentDocMapBackwards = new int[forwards.length];
        int[] backwards = this.shardSegmentDocMapBackwards;
        for (int p = 0; p < forwards.length; ++p) {
            backwards[forwards[p]] = p;
        }
    }

    @Override
    public DocBlock asBlock() {
        return this.block;
    }

    @Override
    public DocVector filter(int ... positions) {
        return new DocVector(this.shards.filter(positions), this.segments.filter(positions), this.docs.filter(positions), null);
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOC;
    }

    @Override
    public boolean isConstant() {
        return this.shards.isConstant() && this.segments.isConstant() && this.docs.isConstant();
    }

    public int hashCode() {
        return Objects.hash(this.shards, this.segments, this.docs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocVector)) {
            return false;
        }
        DocVector other = (DocVector)obj;
        return this.shards.equals(other.shards) && this.segments.equals(other.segments) && this.docs.equals(other.docs);
    }

    private static long ramBytesOrZero(int[] array) {
        return array == null ? 0L : RamUsageEstimator.shallowSizeOf((int[])array);
    }

    public static long ramBytesEstimated(IntVector shards, IntVector segments, IntVector docs, int[] shardSegmentDocMapForwards, int[] shardSegmentDocMapBackwards) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)shards) + RamUsageEstimator.sizeOf((Accountable)segments) + RamUsageEstimator.sizeOf((Accountable)docs) + DocVector.ramBytesOrZero(shardSegmentDocMapForwards) + DocVector.ramBytesOrZero(shardSegmentDocMapBackwards);
    }

    public long ramBytesUsed() {
        return DocVector.ramBytesEstimated(this.shards, this.segments, this.docs, this.shardSegmentDocMapForwards, this.shardSegmentDocMapBackwards);
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.shards.asBlock(), this.segments.asBlock(), this.docs.asBlock()});
    }
}

