/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class DocBlock
extends AbstractVectorBlock
implements Block {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DocBlock.class);
    private final DocVector vector;

    DocBlock(DocVector vector) {
        super(vector.getPositionCount(), vector.blockFactory());
        this.vector = vector;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException();
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocVector asVector() {
        return this.vector;
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOC;
    }

    @Override
    public Block filter(int ... positions) {
        return new DocBlock(this.asVector().filter(positions));
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocBlock)) {
            return false;
        }
        return this == obj || this.vector.equals(((DocBlock)obj).vector);
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)this.vector);
    }

    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        this.released = true;
        Releasables.closeExpectNoException((Releasable)this.vector);
    }

    public static Builder newBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        return new Builder(estimatedSize, blockFactory);
    }

    public static class Builder
    implements Block.Builder {
        private final IntVector.Builder shards;
        private final IntVector.Builder segments;
        private final IntVector.Builder docs;

        private Builder(int estimatedSize, BlockFactory blockFactory) {
            this.shards = IntVector.newVectorBuilder(estimatedSize, blockFactory);
            this.segments = IntVector.newVectorBuilder(estimatedSize, blockFactory);
            this.docs = IntVector.newVectorBuilder(estimatedSize, blockFactory);
        }

        public Builder appendShard(int shard) {
            this.shards.appendInt(shard);
            return this;
        }

        public Builder appendSegment(int segment) {
            this.segments.appendInt(segment);
            return this;
        }

        public Builder appendDoc(int doc) {
            this.docs.appendInt(doc);
            return this;
        }

        @Override
        public Builder appendNull() {
            throw new UnsupportedOperationException("doc blocks can't contain null");
        }

        @Override
        public Builder beginPositionEntry() {
            throw new UnsupportedOperationException("doc blocks only contain one value per position");
        }

        @Override
        public Builder endPositionEntry() {
            throw new UnsupportedOperationException("doc blocks only contain one value per position");
        }

        @Override
        public Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
            DocVector docVector = ((DocBlock)block).asVector();
            for (int i = beginInclusive; i < endExclusive; ++i) {
                this.shards.appendInt(docVector.shards().getInt(i));
                this.segments.appendInt(docVector.segments().getInt(i));
                this.docs.appendInt(docVector.docs().getInt(i));
            }
            return this;
        }

        @Override
        public Block.Builder appendAllValuesToCurrentPosition(Block block) {
            throw new UnsupportedOperationException("DocBlock doesn't support appendBlockAndMerge");
        }

        @Override
        public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
            throw new UnsupportedOperationException("doc blocks only contain one value per position");
        }

        @Override
        public DocBlock build() {
            return new DocVector(this.shards.build(), this.segments.build(), this.docs.build(), null).asBlock();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.shards, this.segments, this.docs});
        }
    }
}

