/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AbstractBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;

public final class ConstantNullBlock
extends AbstractBlock
implements BooleanBlock,
IntBlock,
LongBlock,
DoubleBlock,
BytesRefBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantNullBlock.class);
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Block.class, "ConstantNullBlock", ConstantNullBlock::of);

    ConstantNullBlock(int positionCount) {
        this(positionCount, BlockFactory.getNonBreakingInstance());
    }

    ConstantNullBlock(int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
    }

    @Override
    public ConstantNullVector asVector() {
        return null;
    }

    @Override
    public boolean isNull(int position) {
        return true;
    }

    @Override
    public int nullValuesCount() {
        return this.getPositionCount();
    }

    @Override
    public boolean areAllValuesNull() {
        return true;
    }

    @Override
    public boolean mayHaveNulls() {
        return true;
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return false;
    }

    @Override
    public ElementType elementType() {
        return ElementType.NULL;
    }

    @Override
    public ConstantNullBlock filter(int ... positions) {
        return (ConstantNullBlock)this.blockFactory.newConstantNullBlock(positions.length);
    }

    @Override
    public String getWriteableName() {
        return "ConstantNullBlock";
    }

    static ConstantNullBlock of(StreamInput in) throws IOException {
        return new ConstantNullBlock(in.readVInt());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.getPositionCount());
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public Block expand() {
        return this;
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConstantNullBlock) {
            ConstantNullBlock that = (ConstantNullBlock)obj;
            return this.getPositionCount() == that.getPositionCount();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPositionCount());
    }

    public String toString() {
        return "ConstantNullBlock[positions=" + this.getPositionCount() + "]";
    }

    public void close() {
        if (this.isReleased()) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        this.released = true;
        this.blockFactory.adjustBreaker(-this.ramBytesUsed(), true);
    }

    @Override
    public boolean getBoolean(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public double getDouble(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public int getInt(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public long getLong(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    static class Builder
    implements Block.Builder {
        final BlockFactory blockFactory;
        private int positionCount;
        private boolean closed = false;

        Builder(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
        }

        @Override
        public Builder appendNull() {
            ++this.positionCount;
            return this;
        }

        @Override
        public Builder beginPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder endPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
            for (int i = beginInclusive; i < endExclusive; ++i) {
                if (block.isNull(i)) continue;
                throw new UnsupportedOperationException("can't append non-null values to a null block");
            }
            this.positionCount += endExclusive - beginInclusive;
            return this;
        }

        @Override
        public Block.Builder appendAllValuesToCurrentPosition(Block block) {
            return this.appendNull();
        }

        @Override
        public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Block build() {
            if (this.closed) {
                throw new IllegalStateException("already closed");
            }
            this.close();
            return this.blockFactory.newConstantNullBlock(this.positionCount);
        }

        public void close() {
            this.closed = true;
        }
    }
}

