/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.IntVectorBlock;

public final class ConstantIntVector
extends AbstractVector
implements IntVector {
    static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantIntVector.class);
    private final int value;
    private final IntBlock block;

    public ConstantIntVector(int value, int positionCount) {
        this(value, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public ConstantIntVector(int value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
        this.block = new IntVectorBlock(this);
    }

    @Override
    public int getInt(int position) {
        return this.value;
    }

    @Override
    public IntBlock asBlock() {
        return this.block;
    }

    @Override
    public IntVector filter(int ... positions) {
        return new ConstantIntVector(this.value, positions.length);
    }

    @Override
    public ElementType elementType() {
        return ElementType.INT;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public long ramBytesUsed() {
        return RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntVector) {
            IntVector that = (IntVector)obj;
            return IntVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }

    @Override
    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released vector [" + this + "]");
        }
        this.released = true;
        this.blockFactory.adjustBreaker(-this.ramBytesUsed(), true);
    }
}

