/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BooleanVectorBlock;
import org.elasticsearch.compute.data.ElementType;

public final class ConstantBooleanVector
extends AbstractVector
implements BooleanVector {
    static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantBooleanVector.class);
    private final boolean value;
    private final BooleanBlock block;

    public ConstantBooleanVector(boolean value, int positionCount) {
        this(value, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public ConstantBooleanVector(boolean value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
        this.block = new BooleanVectorBlock(this);
    }

    @Override
    public boolean getBoolean(int position) {
        return this.value;
    }

    @Override
    public BooleanBlock asBlock() {
        return this.block;
    }

    @Override
    public BooleanVector filter(int ... positions) {
        return new ConstantBooleanVector(this.value, positions.length);
    }

    @Override
    public ElementType elementType() {
        return ElementType.BOOLEAN;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public long ramBytesUsed() {
        return RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanVector) {
            BooleanVector that = (BooleanVector)obj;
            return BooleanVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }

    @Override
    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released vector [" + this + "]");
        }
        this.released = true;
        this.blockFactory.adjustBreaker(-this.ramBytesUsed(), true);
    }
}

