/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BytesRefVectorBlock
extends AbstractVectorBlock
implements BytesRefBlock {
    private final BytesRefVector vector;

    BytesRefVectorBlock(BytesRefVector vector) {
        super(vector.getPositionCount(), vector.blockFactory());
        this.vector = vector;
    }

    @Override
    public BytesRefVector asVector() {
        return this.vector;
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        return this.vector.getBytesRef(valueIndex, dest);
    }

    @Override
    public int getTotalValueCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public BytesRefBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefBlock) {
            BytesRefBlock that = (BytesRefBlock)obj;
            return BytesRefBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + this.vector + "]";
    }

    @Override
    public boolean isReleased() {
        return this.released || this.vector.isReleased();
    }

    public void close() {
        if (this.released || this.vector.isReleased()) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        this.released = true;
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

