/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Vector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BytesRefVector
extends Vector {
    public BytesRef getBytesRef(int var1, BytesRef var2);

    @Override
    public BytesRefBlock asBlock();

    @Override
    public BytesRefVector filter(int ... var1);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BytesRefVector vector1, BytesRefVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getBytesRef(pos, new BytesRef()).equals((Object)vector2.getBytesRef(pos, new BytesRef()))) continue;
            return false;
        }
        return true;
    }

    public static int hash(BytesRefVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + vector.getBytesRef(pos, new BytesRef()).hashCode();
        }
        return result;
    }

    public static BytesRefVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        boolean constant = in.readBoolean();
        if (constant && positions > 0) {
            return blockFactory.newConstantBytesRefVector(in.readBytesRef(), positions);
        }
        try (Builder builder = blockFactory.newBytesRefVectorBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendBytesRef(in.readBytesRef());
            }
            BytesRefVector bytesRefVector = builder.build();
            return bytesRefVector;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        out.writeVInt(positions);
        out.writeBoolean(this.isConstant());
        if (this.isConstant() && positions > 0) {
            out.writeBytesRef(this.getBytesRef(0, new BytesRef()));
        } else {
            for (int i = 0; i < positions; ++i) {
                out.writeBytesRef(this.getBytesRef(i, new BytesRef()));
            }
        }
    }

    public static Builder newVectorBuilder(int estimatedSize) {
        return BytesRefVector.newVectorBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    public static Builder newVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        return blockFactory.newBytesRefVectorBuilder(estimatedSize);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendBytesRef(BytesRef var1);

        @Override
        public BytesRefVector build();
    }
}

