/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BooleanVectorBlock
extends AbstractVectorBlock
implements BooleanBlock {
    private final BooleanVector vector;

    BooleanVectorBlock(BooleanVector vector) {
        super(vector.getPositionCount(), vector.blockFactory());
        this.vector = vector;
    }

    @Override
    public BooleanVector asVector() {
        return this.vector;
    }

    @Override
    public boolean getBoolean(int valueIndex) {
        return this.vector.getBoolean(valueIndex);
    }

    @Override
    public int getTotalValueCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public BooleanBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanBlock) {
            BooleanBlock that = (BooleanBlock)obj;
            return BooleanBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + this.vector + "]";
    }

    @Override
    public boolean isReleased() {
        return this.released || this.vector.isReleased();
    }

    public void close() {
        if (this.released || this.vector.isReleased()) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        this.released = true;
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

