/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Vector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BooleanVector
extends Vector {
    public boolean getBoolean(int var1);

    @Override
    public BooleanBlock asBlock();

    @Override
    public BooleanVector filter(int ... var1);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BooleanVector vector1, BooleanVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getBoolean(pos) == vector2.getBoolean(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(BooleanVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + Boolean.hashCode(vector.getBoolean(pos));
        }
        return result;
    }

    public static BooleanVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        boolean constant = in.readBoolean();
        if (constant && positions > 0) {
            return blockFactory.newConstantBooleanVector(in.readBoolean(), positions);
        }
        try (FixedBuilder builder = blockFactory.newBooleanVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendBoolean(in.readBoolean());
            }
            BooleanVector booleanVector = builder.build();
            return booleanVector;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        out.writeVInt(positions);
        out.writeBoolean(this.isConstant());
        if (this.isConstant() && positions > 0) {
            out.writeBoolean(this.getBoolean(0));
        } else {
            for (int i = 0; i < positions; ++i) {
                out.writeBoolean(this.getBoolean(i));
            }
        }
    }

    public static Builder newVectorBuilder(int estimatedSize) {
        return BooleanVector.newVectorBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    public static Builder newVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        return blockFactory.newBooleanVectorBuilder(estimatedSize);
    }

    public static FixedBuilder newVectorFixedBuilder(int size, BlockFactory blockFactory) {
        return blockFactory.newBooleanVectorFixedBuilder(size);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Vector.Builder {
        public FixedBuilder appendBoolean(boolean var1);

        @Override
        public BooleanVector build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendBoolean(boolean var1);

        @Override
        public BooleanVector build();
    }
}

