/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;

public final class BooleanArrayBlock
extends AbstractArrayBlock
implements BooleanBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BooleanArrayBlock.class);
    private final boolean[] values;

    public BooleanArrayBlock(boolean[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        this(values, positionCount, firstValueIndexes, nulls, mvOrdering, BlockFactory.getNonBreakingInstance());
    }

    public BooleanArrayBlock(boolean[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering, blockFactory);
        this.values = values;
    }

    @Override
    public BooleanVector asVector() {
        return null;
    }

    @Override
    public boolean getBoolean(int valueIndex) {
        return this.values[valueIndex];
    }

    @Override
    public BooleanBlock filter(int ... positions) {
        try (BooleanBlock.Builder builder = this.blockFactory.newBooleanBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendBoolean(this.getBoolean(this.getFirstValueIndex(pos)));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendBoolean(this.getBoolean(first + c));
                }
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.mvOrdering(this.mvOrdering()).build();
            return booleanBlock;
        }
    }

    @Override
    public ElementType elementType() {
        return ElementType.BOOLEAN;
    }

    @Override
    public BooleanBlock expand() {
        if (this.firstValueIndexes == null) {
            return this;
        }
        try (BooleanBlock.Builder builder = this.blockFactory.newBooleanBlockBuilder(this.firstValueIndexes[this.getPositionCount()]);){
            for (int pos = 0; pos < this.getPositionCount(); ++pos) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int first = this.getFirstValueIndex(pos);
                int end = first + this.getValueCount(pos);
                for (int i = first; i < end; ++i) {
                    builder.appendBoolean(this.getBoolean(i));
                }
            }
            BooleanBlock booleanBlock = builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING).build();
            return booleanBlock;
        }
    }

    public static long ramBytesEstimated(boolean[] values, int[] firstValueIndexes, BitSet nullsMask) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((boolean[])values) + BlockRamUsageEstimator.sizeOf(firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(nullsMask);
    }

    public long ramBytesUsed() {
        return BooleanArrayBlock.ramBytesEstimated(this.values, this.firstValueIndexes, this.nullsMask);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanBlock) {
            BooleanBlock that = (BooleanBlock)obj;
            return BooleanBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + this.mvOrdering() + ", values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        this.released = true;
        this.blockFactory.adjustBreaker(-this.ramBytesUsed(), true);
    }
}

