/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.List;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public interface Block
extends Accountable,
NamedWriteable,
Releasable {
    public Vector asVector();

    public int getTotalValueCount();

    public int getPositionCount();

    public int getFirstValueIndex(int var1);

    public int getValueCount(int var1);

    public ElementType elementType();

    public BlockFactory blockFactory();

    public boolean isReleased();

    public boolean isNull(int var1);

    public int nullValuesCount();

    public boolean mayHaveNulls();

    public boolean areAllValuesNull();

    public boolean mayHaveMultivaluedFields();

    public Block filter(int ... var1);

    public MvOrdering mvOrdering();

    default public boolean mvDeduplicated() {
        return !this.mayHaveMultivaluedFields() || this.mvOrdering().deduplicated;
    }

    default public boolean mvSortedAscending() {
        return !this.mayHaveMultivaluedFields() || this.mvOrdering().sortedAscending;
    }

    public Block expand();

    public static Block constantNullBlock(int positions) {
        return Block.constantNullBlock(positions, BlockFactory.getNonBreakingInstance());
    }

    public static Block constantNullBlock(int positions, BlockFactory blockFactory) {
        return blockFactory.newConstantNullBlock(positions);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(IntBlock.ENTRY, LongBlock.ENTRY, DoubleBlock.ENTRY, BytesRefBlock.ENTRY, BooleanBlock.ENTRY, ConstantNullBlock.ENTRY);
    }

    public static enum MvOrdering {
        UNORDERED(false, false),
        DEDUPLICATED_UNORDERD(true, false),
        DEDUPLICATED_AND_SORTED_ASCENDING(true, true);

        private final boolean deduplicated;
        private final boolean sortedAscending;

        private MvOrdering(boolean deduplicated, boolean sortedAscending) {
            this.deduplicated = deduplicated;
            this.sortedAscending = sortedAscending;
        }
    }

    public record Ref(Block block, @Nullable Page containedIn) implements Releasable
    {
        public static Ref floating(Block block) {
            return new Ref(block, null);
        }

        public boolean floating() {
            return this.containedIn == null;
        }

        public void close() {
            if (this.floating()) {
                this.block.close();
            }
        }
    }

    public static interface Builder
    extends Releasable {
        public Builder appendNull();

        public Builder beginPositionEntry();

        public Builder endPositionEntry();

        public Builder appendAllValuesToCurrentPosition(Block var1);

        public Builder copyFrom(Block var1, int var2, int var3);

        public Builder mvOrdering(MvOrdering var1);

        public Block build();

        public static Block[] buildAll(Builder ... builders) {
            Releasable[] blocks = new Block[builders.length];
            try {
                for (int b = 0; b < blocks.length; ++b) {
                    blocks[b] = builders[b].build();
                }
            }
            finally {
                if (blocks[blocks.length - 1] == null) {
                    Releasables.closeExpectNoException((Releasable[])blocks);
                }
            }
            return blocks;
        }
    }
}

