/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Vector;

abstract class AbstractVector
implements Vector {
    private final int positionCount;
    protected final BlockFactory blockFactory;
    protected boolean released;

    protected AbstractVector(int positionCount, BlockFactory blockFactory) {
        this.positionCount = positionCount;
        this.blockFactory = blockFactory;
    }

    @Override
    public final int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public final Vector getRow(int position) {
        return this.filter(position);
    }

    @Override
    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released vector [" + this + "]");
        }
        this.released = true;
        this.blockFactory.adjustBreaker(-this.ramBytesUsed(), true);
    }

    @Override
    public final boolean isReleased() {
        return this.released;
    }
}

