/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;

abstract class AbstractBlockBuilder
implements Block.Builder {
    protected final BlockFactory blockFactory;
    protected int[] firstValueIndexes;
    protected BitSet nullsMask;
    protected int valueCount;
    protected int positionCount;
    protected boolean positionEntryIsOpen;
    protected boolean hasNonNullValue;
    protected boolean hasMultiValues;
    protected Block.MvOrdering mvOrdering = Block.MvOrdering.UNORDERED;
    protected long estimatedBytes;
    boolean closed = false;

    protected AbstractBlockBuilder(BlockFactory blockFactory) {
        this.blockFactory = blockFactory;
    }

    @Override
    public AbstractBlockBuilder appendNull() {
        if (this.positionEntryIsOpen) {
            this.endPositionEntry();
        }
        this.ensureCapacity();
        if (this.nullsMask == null) {
            this.nullsMask = new BitSet();
        }
        this.nullsMask.set(this.positionCount);
        if (this.firstValueIndexes != null) {
            this.setFirstValue(this.positionCount, this.valueCount);
        }
        ++this.positionCount;
        this.writeNullValue();
        ++this.valueCount;
        return this;
    }

    protected void writeNullValue() {
    }

    protected abstract int valuesLength();

    @Override
    public AbstractBlockBuilder beginPositionEntry() {
        if (this.firstValueIndexes == null) {
            this.firstValueIndexes = new int[this.positionCount + 1];
            IntStream.range(0, this.positionCount).forEach(i -> {
                this.firstValueIndexes[i] = i;
            });
        }
        if (this.positionEntryIsOpen) {
            this.endPositionEntry();
        }
        this.positionEntryIsOpen = true;
        this.setFirstValue(this.positionCount, this.valueCount);
        return this;
    }

    @Override
    public AbstractBlockBuilder endPositionEntry() {
        ++this.positionCount;
        this.positionEntryIsOpen = false;
        if (!this.hasMultiValues && this.valueCount != this.positionCount) {
            this.hasMultiValues = true;
        }
        return this;
    }

    protected final boolean isDense() {
        return this.nullsMask == null;
    }

    protected final boolean singleValued() {
        return !this.hasMultiValues;
    }

    protected final void updatePosition() {
        if (!this.positionEntryIsOpen) {
            if (this.firstValueIndexes != null) {
                this.setFirstValue(this.positionCount, this.valueCount - 1);
            }
            ++this.positionCount;
        }
    }

    protected final void finish() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        if (this.positionEntryIsOpen) {
            this.endPositionEntry();
        }
        if (this.firstValueIndexes != null) {
            this.setFirstValue(this.positionCount, this.valueCount);
        }
    }

    protected final void built() {
        this.closed = true;
        this.estimatedBytes = 0L;
    }

    protected abstract void growValuesArray(int var1);

    protected abstract int elementSize();

    protected final void ensureCapacity() {
        int valuesLength = this.valuesLength();
        if (this.valueCount < valuesLength) {
            return;
        }
        int newSize = AbstractBlockBuilder.calculateNewArraySize(valuesLength);
        this.adjustBreaker((long)(newSize - valuesLength) * (long)this.elementSize());
        this.growValuesArray(newSize);
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.adjustBreaker(-this.estimatedBytes);
            this.extraClose();
        }
    }

    protected void extraClose() {
    }

    static int calculateNewArraySize(int currentSize) {
        return currentSize + (currentSize >> 1);
    }

    protected void adjustBreaker(long deltaBytes) {
        this.blockFactory.adjustBreaker(deltaBytes, false);
        this.estimatedBytes += deltaBytes;
        assert (this.estimatedBytes >= 0L);
    }

    private void setFirstValue(int position, int value) {
        if (position >= this.firstValueIndexes.length) {
            int currentSize = this.firstValueIndexes.length;
            this.adjustBreaker((long)(position + 1 - currentSize) * 4L);
            this.firstValueIndexes = Arrays.copyOf(this.firstValueIndexes, position + 1);
        }
        this.firstValueIndexes[position] = value;
    }
}

