/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.BitSet;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Nullable;

abstract class AbstractBlock
implements Block {
    private final int positionCount;
    @Nullable
    protected final int[] firstValueIndexes;
    @Nullable
    protected final BitSet nullsMask;
    protected final BlockFactory blockFactory;
    protected boolean released = false;

    protected AbstractBlock(int positionCount, BlockFactory blockFactory) {
        assert (positionCount >= 0);
        this.positionCount = positionCount;
        this.blockFactory = blockFactory;
        this.firstValueIndexes = null;
        this.nullsMask = null;
    }

    protected AbstractBlock(int positionCount, @Nullable int[] firstValueIndexes, @Nullable BitSet nullsMask, BlockFactory blockFactory) {
        assert (positionCount >= 0);
        this.positionCount = positionCount;
        this.blockFactory = blockFactory;
        this.firstValueIndexes = firstValueIndexes;
        BitSet bitSet = this.nullsMask = nullsMask == null || nullsMask.isEmpty() ? null : nullsMask;
        assert (nullsMask != null || firstValueIndexes != null) : "Create VectorBlock instead";
    }

    @Override
    public int getTotalValueCount() {
        if (this.firstValueIndexes == null) {
            return this.positionCount - this.nullValuesCount();
        }
        return this.firstValueIndexes[this.positionCount] - this.nullValuesCount();
    }

    @Override
    public final int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getFirstValueIndex(int position) {
        return this.firstValueIndexes == null ? position : this.firstValueIndexes[position];
    }

    @Override
    public int getValueCount(int position) {
        return this.isNull(position) ? 0 : (this.firstValueIndexes == null ? 1 : this.firstValueIndexes[position + 1] - this.firstValueIndexes[position]);
    }

    @Override
    public boolean isNull(int position) {
        return this.mayHaveNulls() && this.nullsMask.get(position);
    }

    @Override
    public boolean mayHaveNulls() {
        return this.nullsMask != null;
    }

    @Override
    public int nullValuesCount() {
        return this.mayHaveNulls() ? this.nullsMask.cardinality() : 0;
    }

    @Override
    public boolean areAllValuesNull() {
        return this.nullValuesCount() == this.getPositionCount();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }
}

