/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.MultivalueDedupeBoolean;

final class BooleanBlockHash
extends BlockHash {
    private final int channel;
    private final boolean[] everSeen = new boolean[3];

    BooleanBlockHash(int channel, DriverContext driverContext) {
        super(driverContext);
        this.channel = channel;
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.everSeen[0] = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
        }
        BooleanBlock booleanBlock = (BooleanBlock)page.getBlock(this.channel);
        BooleanVector booleanVector = booleanBlock.asVector();
        if (booleanVector == null) {
            try (IntBlock groupIds = this.add(booleanBlock);){
                addInput.add(0, groupIds);
            }
        }
        try (IntBlock groupIds = this.add(booleanVector).asBlock();){
            addInput.add(0, groupIds.asVector());
        }
    }

    private IntVector add(BooleanVector vector) {
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = IntVector.newVectorFixedBuilder(positions, this.blockFactory);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(MultivalueDedupeBoolean.hashOrd(this.everSeen, vector.getBoolean(i)));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    private IntBlock add(BooleanBlock block) {
        return new MultivalueDedupeBoolean(Block.Ref.floating(block)).hash(this.everSeen);
    }

    public BooleanBlock[] getKeys() {
        BooleanBlock.Builder builder = BooleanBlock.newBlockBuilder(this.everSeen.length);
        if (this.everSeen[0]) {
            builder.appendNull();
        }
        if (this.everSeen[1]) {
            builder.appendBoolean(false);
        }
        if (this.everSeen[2]) {
            builder.appendBoolean(true);
        }
        return new BooleanBlock[]{builder.build()};
    }

    @Override
    public IntVector nonEmpty() {
        IntVector.Builder builder = IntVector.newVectorBuilder(this.everSeen.length);
        for (int i = 0; i < this.everSeen.length; ++i) {
            if (!this.everSeen[i]) continue;
            builder.appendInt(i);
        }
        return builder.build();
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        BitArray seen = new BitArray((long)this.everSeen.length, bigArrays);
        for (int i = 0; i < this.everSeen.length; ++i) {
            if (!this.everSeen[i]) continue;
            seen.set((long)i);
        }
        return seen;
    }

    public void close() {
    }

    public String toString() {
        return "BooleanBlockHash{channel=" + this.channel + ", seenFalse=" + this.everSeen[1] + ", seenTrue=" + this.everSeen[2] + ", seenNull=" + this.everSeen[0] + "}";
    }
}

