/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LongState;
import org.elasticsearch.compute.aggregation.SumIntAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SumIntAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("sum", ElementType.LONG), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final LongState state;
    private final List<Integer> channels;

    public SumIntAggregatorFunction(DriverContext driverContext, List<Integer> channels, LongState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SumIntAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SumIntAggregatorFunction(driverContext, channels, new LongState(SumIntAggregator.init()));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        IntBlock block = (IntBlock)uncastBlock;
        IntVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(IntVector vector) {
        this.state.seen(true);
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            this.state.longValue(SumIntAggregator.combine(this.state.longValue(), vector.getInt(i)));
        }
    }

    private void addRawBlock(IntBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            this.state.seen(true);
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                this.state.longValue(SumIntAggregator.combine(this.state.longValue(), block.getInt(i)));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SumIntAggregatorFunction.intermediateStateDesc().size());
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        LongVector sum = ((LongBlock)page.getBlock(this.channels.get(0))).asVector();
        BooleanVector seen = ((BooleanBlock)page.getBlock(this.channels.get(1))).asVector();
        assert (sum.getPositionCount() == 1);
        assert (sum.getPositionCount() == seen.getPositionCount());
        if (seen.getBoolean(0)) {
            this.state.longValue(SumIntAggregator.combine(this.state.longValue(), sum.getLong(0)));
            this.state.seen(true);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset) {
        this.state.toIntermediate(blocks, offset);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = Block.constantNullBlock(1, driverContext.blockFactory());
            return;
        }
        blocks[offset] = LongBlock.newConstantBlockWith(this.state.longValue(), 1, driverContext.blockFactory());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

