/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.SumDoubleAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SumDoubleGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("value", ElementType.DOUBLE), new IntermediateStateDesc("delta", ElementType.DOUBLE), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final SumDoubleAggregator.GroupingSumState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final BigArrays bigArrays;

    public SumDoubleGroupingAggregatorFunction(List<Integer> channels, SumDoubleAggregator.GroupingSumState state, DriverContext driverContext, BigArrays bigArrays) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.bigArrays = bigArrays;
    }

    public static SumDoubleGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, BigArrays bigArrays) {
        return new SumDoubleGroupingAggregatorFunction(channels, SumDoubleAggregator.initGrouping(bigArrays), driverContext, bigArrays);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessPage(SeenGroupIds seenGroupIds, Page page) {
        Object uncastValuesBlock = page.getBlock(this.channels.get(0));
        if (uncastValuesBlock.areAllValuesNull()) {
            this.state.enableGroupIdTracking(seenGroupIds);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                }
            };
        }
        final DoubleBlock valuesBlock = (DoubleBlock)uncastValuesBlock;
        final DoubleVector valuesVector = valuesBlock.asVector();
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    SumDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SumDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntBlock groupIds) {
                SumDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SumDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, DoubleBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                SumDoubleAggregator.combine(this.state, groupId, values.getDouble(v));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, DoubleVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            SumDoubleAggregator.combine(this.state, groupId, values.getDouble(groupPosition + positionOffset));
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, DoubleBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = Math.toIntExact(groups.getInt(g));
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    SumDoubleAggregator.combine(this.state, groupId, values.getDouble(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, DoubleVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = Math.toIntExact(groups.getInt(g));
                SumDoubleAggregator.combine(this.state, groupId, values.getDouble(groupPosition + positionOffset));
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        DoubleVector value = ((DoubleBlock)page.getBlock(this.channels.get(0))).asVector();
        DoubleVector delta = ((DoubleBlock)page.getBlock(this.channels.get(1))).asVector();
        BooleanVector seen = ((BooleanBlock)page.getBlock(this.channels.get(2))).asVector();
        assert (value.getPositionCount() == delta.getPositionCount() && value.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = Math.toIntExact(groups.getInt(groupPosition));
            SumDoubleAggregator.combineIntermediate(this.state, groupId, value.getDouble(groupPosition + positionOffset), delta.getDouble(groupPosition + positionOffset), seen.getBoolean(groupPosition + positionOffset));
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + this.getClass() + "; got " + input.getClass());
        }
        SumDoubleAggregator.GroupingSumState inState = ((SumDoubleGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        SumDoubleAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        blocks[offset] = SumDoubleAggregator.evaluateFinal(this.state, selected, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

