/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final BigArrays bigArrays;
    private final List<Integer> channels;
    private final double percentile;

    public PercentileIntAggregatorFunctionSupplier(BigArrays bigArrays, List<Integer> channels, double percentile) {
        this.bigArrays = bigArrays;
        this.channels = channels;
        this.percentile = percentile;
    }

    @Override
    public PercentileIntAggregatorFunction aggregator(DriverContext driverContext) {
        return PercentileIntAggregatorFunction.create(driverContext, this.channels, this.percentile);
    }

    @Override
    public PercentileIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return PercentileIntGroupingAggregatorFunction.create(this.channels, driverContext, this.bigArrays, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of ints";
    }
}

