/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ConstantBooleanVector;
import org.elasticsearch.compute.data.ConstantLongVector;

final class LongState
implements AggregatorState {
    private long value;
    private boolean seen;

    LongState() {
        this(0L);
    }

    LongState(long init) {
        this.value = init;
    }

    long longValue() {
        return this.value;
    }

    void longValue(long value) {
        this.value = value;
    }

    boolean seen() {
        return this.seen;
    }

    void seen(boolean seen) {
        this.seen = seen;
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset) {
        assert (blocks.length >= offset + 2);
        blocks[offset + 0] = new ConstantLongVector(this.value, 1).asBlock();
        blocks[offset + 1] = new ConstantBooleanVector(this.seen, 1).asBlock();
    }

    public void close() {
    }
}

