/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ConstantBooleanVector;
import org.elasticsearch.compute.data.ConstantDoubleVector;

final class DoubleState
implements AggregatorState {
    private double value;
    private boolean seen;

    DoubleState() {
        this(0.0);
    }

    DoubleState(double init) {
        this.value = init;
    }

    double doubleValue() {
        return this.value;
    }

    void doubleValue(double value) {
        this.value = value;
    }

    boolean seen() {
        return this.seen;
    }

    void seen(boolean seen) {
        this.seen = seen;
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset) {
        assert (blocks.length >= offset + 2);
        blocks[offset + 0] = new ConstantDoubleVector(this.value, 1).asBlock();
        blocks[offset + 1] = new ConstantBooleanVector(this.seen, 1).asBlock();
    }

    public void close() {
    }
}

