/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.CountDistinctLongAggregator;
import org.elasticsearch.compute.aggregation.HllStates;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class CountDistinctLongAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("hll", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final HllStates.SingleState state;
    private final List<Integer> channels;
    private final BigArrays bigArrays;
    private final int precision;

    public CountDistinctLongAggregatorFunction(DriverContext driverContext, List<Integer> channels, HllStates.SingleState state, BigArrays bigArrays, int precision) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.bigArrays = bigArrays;
        this.precision = precision;
    }

    public static CountDistinctLongAggregatorFunction create(DriverContext driverContext, List<Integer> channels, BigArrays bigArrays, int precision) {
        return new CountDistinctLongAggregatorFunction(driverContext, channels, CountDistinctLongAggregator.initSingle(bigArrays, precision), bigArrays, precision);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        LongBlock block = (LongBlock)uncastBlock;
        LongVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(LongVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            CountDistinctLongAggregator.combine(this.state, vector.getLong(i));
        }
    }

    private void addRawBlock(LongBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                CountDistinctLongAggregator.combine(this.state, block.getLong(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + CountDistinctLongAggregatorFunction.intermediateStateDesc().size());
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        BytesRefVector hll = ((BytesRefBlock)page.getBlock(this.channels.get(0))).asVector();
        assert (hll.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        CountDistinctLongAggregator.combineIntermediate(this.state, hll.getBytesRef(0, scratch));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset) {
        this.state.toIntermediate(blocks, offset);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = CountDistinctLongAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

