/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.CountDistinctBooleanAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class CountDistinctBooleanAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("fbit", ElementType.BOOLEAN), new IntermediateStateDesc("tbit", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final CountDistinctBooleanAggregator.SingleState state;
    private final List<Integer> channels;

    public CountDistinctBooleanAggregatorFunction(DriverContext driverContext, List<Integer> channels, CountDistinctBooleanAggregator.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static CountDistinctBooleanAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new CountDistinctBooleanAggregatorFunction(driverContext, channels, CountDistinctBooleanAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page) {
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        BooleanBlock block = (BooleanBlock)uncastBlock;
        BooleanVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector);
        } else {
            this.addRawBlock(block);
        }
    }

    private void addRawVector(BooleanVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            CountDistinctBooleanAggregator.combine(this.state, vector.getBoolean(i));
        }
    }

    private void addRawBlock(BooleanBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                CountDistinctBooleanAggregator.combine(this.state, block.getBoolean(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + CountDistinctBooleanAggregatorFunction.intermediateStateDesc().size());
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        BooleanVector fbit = ((BooleanBlock)page.getBlock(this.channels.get(0))).asVector();
        BooleanVector tbit = ((BooleanBlock)page.getBlock(this.channels.get(1))).asVector();
        assert (fbit.getPositionCount() == 1);
        assert (fbit.getPositionCount() == tbit.getPositionCount());
        CountDistinctBooleanAggregator.combineIntermediate(this.state, fbit.getBoolean(0), tbit.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset) {
        this.state.toIntermediate(blocks, offset);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = CountDistinctBooleanAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

