/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.function.Function;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;

public class Aggregator
implements Releasable {
    public static final Object[] EMPTY_PARAMS = new Object[0];
    private final AggregatorFunction aggregatorFunction;
    private final AggregatorMode mode;

    public Aggregator(AggregatorFunction aggregatorFunction, AggregatorMode mode) {
        this.aggregatorFunction = aggregatorFunction;
        this.mode = mode;
    }

    public int evaluateBlockCount() {
        return this.mode.isOutputPartial() ? this.aggregatorFunction.intermediateBlockCount() : 1;
    }

    public void processPage(Page page) {
        if (this.mode.isInputPartial()) {
            this.aggregatorFunction.addIntermediateInput(page);
        } else {
            this.aggregatorFunction.addRawInput(page);
        }
    }

    public void evaluate(Block[] blocks, int offset, DriverContext driverContext) {
        if (this.mode.isOutputPartial()) {
            this.aggregatorFunction.evaluateIntermediate(blocks, offset);
        } else {
            this.aggregatorFunction.evaluateFinal(blocks, offset, driverContext);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("aggregatorFunction=").append(this.aggregatorFunction).append(", ");
        sb.append("mode=").append((Object)this.mode);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.aggregatorFunction.close();
    }

    public static interface Factory
    extends Function<DriverContext, Aggregator>,
    Describable {
    }
}

