/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamLifecycleAction
extends ActionType<Response> {
    public static final GetDataStreamLifecycleAction INSTANCE = new GetDataStreamLifecycleAction();
    public static final String NAME = "indices:admin/data_stream/lifecycle/get";

    private GetDataStreamLifecycleAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamLifecycle> dataStreamLifecycles;
        @Nullable
        private final RolloverConfiguration rolloverConfiguration;

        public Response(List<DataStreamLifecycle> dataStreamLifecycles) {
            this(dataStreamLifecycles, null);
        }

        public Response(List<DataStreamLifecycle> dataStreamLifecycles, @Nullable RolloverConfiguration rolloverConfiguration) {
            this.dataStreamLifecycles = dataStreamLifecycles;
            this.rolloverConfiguration = rolloverConfiguration;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readCollectionAsList(DataStreamLifecycle::new), (RolloverConfiguration)in.readOptionalWriteable(RolloverConfiguration::new));
        }

        public List<DataStreamLifecycle> getDataStreamLifecycles() {
            return this.dataStreamLifecycles;
        }

        @Nullable
        public RolloverConfiguration getRolloverConfiguration() {
            return this.rolloverConfiguration;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.dataStreamLifecycles);
            out.writeOptionalWriteable((Writeable)this.rolloverConfiguration);
        }

        public Iterator<ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> {
                builder.startObject();
                builder.startArray(DATA_STREAMS_FIELD.getPreferredName());
                return builder;
            }), Iterators.map(this.dataStreamLifecycles.iterator(), dataStreamLifecycle -> (builder, params) -> dataStreamLifecycle.toXContent(builder, params, this.rolloverConfiguration)), Iterators.single((builder, params) -> {
                builder.endArray();
                builder.endObject();
                return builder;
            })});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.dataStreamLifecycles.equals(response.dataStreamLifecycles) && Objects.equals(this.rolloverConfiguration, response.rolloverConfiguration);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreamLifecycles, this.rolloverConfiguration);
        }

        public record DataStreamLifecycle(String dataStreamName, @Nullable org.elasticsearch.cluster.metadata.DataStreamLifecycle lifecycle) implements Writeable,
        ToXContentObject
        {
            public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
            public static final ParseField LIFECYCLE_FIELD = new ParseField("lifecycle", new String[0]);

            DataStreamLifecycle(StreamInput in) throws IOException {
                this(in.readString(), (org.elasticsearch.cluster.metadata.DataStreamLifecycle)in.readOptionalWriteable(org.elasticsearch.cluster.metadata.DataStreamLifecycle::new));
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.dataStreamName);
                out.writeOptionalWriteable((Writeable)this.lifecycle);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return this.toXContent(builder, params, null);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
                builder.startObject();
                builder.field(NAME_FIELD.getPreferredName(), this.dataStreamName);
                if (this.lifecycle != null) {
                    builder.field(LIFECYCLE_FIELD.getPreferredName());
                    this.lifecycle.toXContent(builder, params, rolloverConfiguration);
                }
                builder.endObject();
                return builder;
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
        private boolean includeDefaults = false;

        public Request(String[] names) {
            this.names = names;
        }

        public Request(String[] names, boolean includeDefaults) {
            this.names = names;
            this.includeDefaults = includeDefaults;
        }

        public String[] getNames() {
            return this.names;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
            this.includeDefaults = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            out.writeBoolean(this.includeDefaults);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.names, request.names) && this.indicesOptions.equals((Object)request.indicesOptions) && this.includeDefaults == request.includeDefaults;
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.includeDefaults);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        public String[] indices() {
            return this.names;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }
    }
}

