/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteDataStreamLifecycleAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteDataStreamLifecycleAction INSTANCE = new DeleteDataStreamLifecycleAction();
    public static final String NAME = "indices:admin/data_stream/lifecycle/delete";

    private DeleteDataStreamLifecycleAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static final class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false);

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public Request(String[] names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String[] indices() {
            return this.names;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.names, request.names) && Objects.equals(this.indicesOptions, request.indicesOptions);
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }
    }
}

