/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class DataStreamLifecycleErrorStore {
    public static final int MAX_ERROR_MESSAGE_LENGTH = 1000;
    private final ConcurrentMap<String, String> indexNameToError = new ConcurrentHashMap<String, String>();

    @Nullable
    public String recordError(String indexName, Exception e) {
        String exceptionToString = Strings.toString((builder, params) -> {
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)e);
            return builder;
        });
        String recordedError = Strings.substring((String)exceptionToString, (int)0, (int)1000);
        return this.indexNameToError.put(indexName, recordedError);
    }

    public void clearRecordedError(String indexName) {
        this.indexNameToError.remove(indexName);
    }

    public void clearStore() {
        this.indexNameToError.clear();
    }

    @Nullable
    public String getError(String indexName) {
        return (String)this.indexNameToError.get(indexName);
    }

    public List<String> getAllIndices() {
        return List.copyOf(this.indexNameToError.keySet());
    }
}

