/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public final class EsqlDataTypes {
    public static final DataType DATE_PERIOD = new DataType("DATE_PERIOD", null, 12, false, false, false);
    public static final DataType TIME_DURATION = new DataType("TIME_DURATION", null, 12, false, false, false);
    private static final Collection<DataType> TYPES = Stream.of(DataTypes.BOOLEAN, DataTypes.UNSUPPORTED, DataTypes.NULL, DataTypes.BYTE, DataTypes.SHORT, DataTypes.INTEGER, DataTypes.LONG, DataTypes.DOUBLE, DataTypes.FLOAT, DataTypes.HALF_FLOAT, DataTypes.KEYWORD, DataTypes.TEXT, DataTypes.DATETIME, DATE_PERIOD, TIME_DURATION, DataTypes.IP, DataTypes.OBJECT, DataTypes.NESTED, DataTypes.SCALED_FLOAT, DataTypes.VERSION, DataTypes.UNSIGNED_LONG).sorted(Comparator.comparing(DataType::typeName)).toList();
    private static final Map<String, DataType> NAME_TO_TYPE = TYPES.stream().collect(Collectors.toUnmodifiableMap(DataType::typeName, t -> t));
    private static final Map<String, DataType> ES_TO_TYPE;

    private EsqlDataTypes() {
    }

    public static Collection<DataType> types() {
        return TYPES;
    }

    public static DataType fromTypeName(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public static DataType fromName(String name) {
        DataType type = ES_TO_TYPE.get(name);
        return type != null ? type : DataTypes.UNSUPPORTED;
    }

    public static DataType fromJava(Object value) {
        if (value == null) {
            return DataTypes.NULL;
        }
        if (value instanceof Boolean) {
            return DataTypes.BOOLEAN;
        }
        if (value instanceof Integer) {
            return DataTypes.INTEGER;
        }
        if (value instanceof Long) {
            return DataTypes.LONG;
        }
        if (value instanceof Double) {
            return DataTypes.DOUBLE;
        }
        if (value instanceof Float) {
            return DataTypes.FLOAT;
        }
        if (value instanceof String || value instanceof Character || value instanceof BytesRef) {
            return DataTypes.KEYWORD;
        }
        return null;
    }

    public static boolean isUnsupported(DataType type) {
        return DataTypes.isUnsupported((DataType)type);
    }

    public static String outputType(DataType type) {
        if (type != null && type.esType() != null) {
            return type.esType();
        }
        return "unsupported";
    }

    public static boolean isString(DataType t) {
        return t == DataTypes.KEYWORD || t == DataTypes.TEXT;
    }

    public static boolean isPrimitive(DataType t) {
        return t != DataTypes.OBJECT && t != DataTypes.NESTED;
    }

    public static boolean isDateTimeOrTemporal(DataType t) {
        return DataTypes.isDateTime((DataType)t) || EsqlDataTypes.isTemporalAmount(t);
    }

    public static boolean isTemporalAmount(DataType t) {
        return t == DATE_PERIOD || t == TIME_DURATION;
    }

    public static boolean isRepresentable(DataType t) {
        return t != DataTypes.OBJECT && t != DataTypes.NESTED && t != DataTypes.UNSUPPORTED && t != DATE_PERIOD && t != TIME_DURATION && t != DataTypes.BYTE && t != DataTypes.SHORT && t != DataTypes.FLOAT && t != DataTypes.SCALED_FLOAT && t != DataTypes.HALF_FLOAT;
    }

    public static boolean areCompatible(DataType left, DataType right) {
        if (left == right) {
            return true;
        }
        return left == DataTypes.NULL || right == DataTypes.NULL || EsqlDataTypes.isString(left) && EsqlDataTypes.isString(right) || left.isNumeric() && right.isNumeric();
    }

    public static DataType widenSmallNumericTypes(DataType type) {
        if (type == DataTypes.BYTE || type == DataTypes.SHORT) {
            return DataTypes.INTEGER;
        }
        if (type == DataTypes.HALF_FLOAT || type == DataTypes.FLOAT || type == DataTypes.SCALED_FLOAT) {
            return DataTypes.DOUBLE;
        }
        return type;
    }

    static {
        Map<String, DataType> map = TYPES.stream().filter(e -> e.esType() != null).collect(Collectors.toMap(DataType::esType, t -> t));
        ES_TO_TYPE = Collections.unmodifiableMap(map);
    }
}

