/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.Version;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.execution.PlanExecutor;
import org.elasticsearch.xpack.esql.plugin.EsqlStatsRequest;
import org.elasticsearch.xpack.esql.plugin.EsqlStatsResponse;

public class TransportEsqlStatsAction
extends TransportNodesAction<EsqlStatsRequest, EsqlStatsResponse, EsqlStatsRequest.NodeStatsRequest, EsqlStatsResponse.NodeStatsResponse> {
    private final PlanExecutor planExecutor;

    @Inject
    public TransportEsqlStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor) {
        super("cluster:monitor/xpack/esql/stats/dist", threadPool, clusterService, transportService, actionFilters, EsqlStatsRequest::new, EsqlStatsRequest.NodeStatsRequest::new, (Executor)threadPool.executor("management"));
        this.planExecutor = planExecutor;
    }

    protected void resolveRequest(EsqlStatsRequest request, ClusterState clusterState) {
        String[] nodesIds = clusterState.nodes().resolveNodes(request.nodesIds());
        DiscoveryNode[] concreteNodes = (DiscoveryNode[])Arrays.stream(nodesIds).map(arg_0 -> ((DiscoveryNodes)clusterState.nodes()).get(arg_0)).filter(n -> n.getVersion().onOrAfter((VersionId)Version.V_8_11_0)).toArray(DiscoveryNode[]::new);
        request.setConcreteNodes(concreteNodes);
    }

    protected EsqlStatsResponse newResponse(EsqlStatsRequest request, List<EsqlStatsResponse.NodeStatsResponse> nodes, List<FailedNodeException> failures) {
        return new EsqlStatsResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected EsqlStatsRequest.NodeStatsRequest newNodeRequest(EsqlStatsRequest request) {
        return new EsqlStatsRequest.NodeStatsRequest(request);
    }

    protected EsqlStatsResponse.NodeStatsResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new EsqlStatsResponse.NodeStatsResponse(in);
    }

    protected EsqlStatsResponse.NodeStatsResponse nodeOperation(EsqlStatsRequest.NodeStatsRequest request, Task task) {
        EsqlStatsResponse.NodeStatsResponse statsResponse = new EsqlStatsResponse.NodeStatsResponse(this.clusterService.localNode());
        statsResponse.setStats(this.planExecutor.metrics().stats());
        return statsResponse;
    }
}

