/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.time.ZoneOffset;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.execution.PlanExecutor;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plugin.ComputeService;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public class TransportEsqlQueryAction
extends HandledTransportAction<EsqlQueryRequest, EsqlQueryResponse> {
    private final PlanExecutor planExecutor;
    private final ComputeService computeService;
    private final ExchangeService exchangeService;
    private final ClusterService clusterService;
    private final Executor requestExecutor;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final EnrichLookupService enrichLookupService;

    @Inject
    public TransportEsqlQueryAction(TransportService transportService, ActionFilters actionFilters, PlanExecutor planExecutor, SearchService searchService, ExchangeService exchangeService, ClusterService clusterService, ThreadPool threadPool, BigArrays bigArrays, BlockFactory blockFactory) {
        super("indices:data/read/esql", transportService, actionFilters, EsqlQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.planExecutor = planExecutor;
        this.clusterService = clusterService;
        this.requestExecutor = threadPool.executor("esql");
        exchangeService.registerTransportHandler(transportService);
        this.exchangeService = exchangeService;
        this.enrichPolicyResolver = new EnrichPolicyResolver(clusterService, transportService, planExecutor.indexResolver());
        this.enrichLookupService = new EnrichLookupService(clusterService, searchService, transportService, bigArrays, blockFactory);
        this.computeService = new ComputeService(searchService, transportService, exchangeService, this.enrichLookupService, threadPool, bigArrays, blockFactory);
    }

    protected void doExecute(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        this.requestExecutor.execute((Runnable)ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, (ActionListener<EsqlQueryResponse>)l)));
    }

    private void doExecuteForked(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        EsqlConfiguration configuration = new EsqlConfiguration(request.zoneId() != null ? request.zoneId() : ZoneOffset.UTC, request.locale() != null ? request.locale() : Locale.US, null, this.clusterService.getClusterName().value(), request.pragmas(), (Integer)this.clusterService.getClusterSettings().get(EsqlPlugin.QUERY_RESULT_TRUNCATION_MAX_SIZE), (Integer)this.clusterService.getClusterSettings().get(EsqlPlugin.QUERY_RESULT_TRUNCATION_DEFAULT_SIZE), request.query());
        String sessionId = this.sessionID(task);
        this.planExecutor.esql(request, sessionId, configuration, this.enrichPolicyResolver, (ActionListener<PhysicalPlan>)listener.delegateFailureAndWrap((delegate, physicalPlan) -> this.computeService.execute(sessionId, (CancellableTask)task, (PhysicalPlan)((Object)physicalPlan), configuration, (ActionListener<List<Page>>)delegate.map(pages -> {
            List<ColumnInfo> columns = physicalPlan.output().stream().map(c -> new ColumnInfo(c.qualifiedName(), EsqlDataTypes.outputType(c.dataType()))).toList();
            return new EsqlQueryResponse(columns, (List<Page>)pages, request.columnar());
        }))));
    }

    final String sessionID(Task task) {
        return new TaskId(this.clusterService.localNode().getId(), task.getId()).toString();
    }

    public ExchangeService exchangeService() {
        return this.exchangeService;
    }

    public EnrichLookupService enrichLookupService() {
        return this.enrichLookupService;
    }
}

