/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.List;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowFunctions;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.DissectExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.GrokExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.OrderExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.RowExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;

public class Mapper {
    private final FunctionRegistry functionRegistry;
    private final boolean localMode;

    public Mapper(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
        this.localMode = false;
    }

    public Mapper(boolean localMode) {
        this.functionRegistry = null;
        this.localMode = localMode;
    }

    public PhysicalPlan map(LogicalPlan p) {
        if (p instanceof EsRelation) {
            EsRelation esRelation = (EsRelation)p;
            return this.localMode ? new EsSourceExec(esRelation) : new FragmentExec(p);
        }
        if (p instanceof Row) {
            Row row = (Row)p;
            return new RowExec(row.source(), row.fields());
        }
        if (p instanceof LocalRelation) {
            LocalRelation local = (LocalRelation)p;
            return new LocalSourceExec(local.source(), local.output(), local.supplier());
        }
        if (p instanceof ShowFunctions) {
            ShowFunctions showFunctions = (ShowFunctions)p;
            return new ShowExec(showFunctions.source(), showFunctions.output(), showFunctions.values(this.functionRegistry));
        }
        if (p instanceof ShowInfo) {
            ShowInfo showInfo = (ShowInfo)p;
            return new ShowExec(showInfo.source(), showInfo.output(), showInfo.values());
        }
        if (p instanceof UnaryPlan) {
            UnaryPlan ua = (UnaryPlan)p;
            PhysicalPlan child = this.map(ua.child());
            PhysicalPlan plan = null;
            plan = child instanceof FragmentExec && !Mapper.isPipelineBreaker(p) ? new FragmentExec(p) : this.map(ua, child);
            return plan;
        }
        throw new EsqlIllegalArgumentException("unsupported logical plan node [" + p.nodeName() + "]");
    }

    private static boolean isPipelineBreaker(LogicalPlan p) {
        return p instanceof Aggregate || p instanceof TopN || p instanceof Limit || p instanceof OrderBy;
    }

    private PhysicalPlan map(UnaryPlan p, PhysicalPlan child) {
        if (p instanceof Filter) {
            Filter f = (Filter)p;
            return new FilterExec(f.source(), child, f.condition());
        }
        if (p instanceof Project) {
            Project pj = (Project)p;
            return new ProjectExec(pj.source(), child, pj.projections());
        }
        if (p instanceof Eval) {
            Eval eval = (Eval)p;
            return new EvalExec(eval.source(), child, eval.fields());
        }
        if (p instanceof Dissect) {
            Dissect dissect = (Dissect)p;
            return new DissectExec(dissect.source(), child, dissect.input(), dissect.parser(), dissect.extractedFields());
        }
        if (p instanceof Grok) {
            Grok grok = (Grok)p;
            return new GrokExec(grok.source(), child, grok.input(), grok.parser(), grok.extractedFields());
        }
        if (p instanceof Enrich) {
            Enrich enrich = (Enrich)p;
            return new EnrichExec(enrich.source(), child, enrich.matchField(), enrich.policy().policyName(), enrich.policy().policy().getMatchField(), enrich.policy().index().get(), enrich.enrichFields());
        }
        if (p instanceof MvExpand) {
            MvExpand mvExpand = (MvExpand)p;
            return new MvExpandExec(mvExpand.source(), this.map(mvExpand.child()), mvExpand.target(), mvExpand.expanded());
        }
        if (p instanceof Limit) {
            Limit limit = (Limit)p;
            return this.map(limit, child);
        }
        if (p instanceof OrderBy) {
            OrderBy o = (OrderBy)p;
            return this.map(o, child);
        }
        if (p instanceof TopN) {
            TopN topN = (TopN)p;
            return this.map(topN, child);
        }
        if (p instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)p;
            return this.map(aggregate, child);
        }
        throw new EsqlIllegalArgumentException("unsupported unary logical plan node [" + p.nodeName() + "]");
    }

    private PhysicalPlan map(Aggregate aggregate, PhysicalPlan child) {
        if (this.localMode) {
            child = Mapper.aggExec(aggregate, child, AggregateExec.Mode.PARTIAL);
        } else {
            if ((child = this.addExchangeForFragment((LogicalPlan)aggregate, child)) instanceof ExchangeExec) {
                ExchangeExec exchange = (ExchangeExec)child;
                List<Attribute> output = AbstractPhysicalOperationProviders.intermediateAttributes(aggregate.aggregates(), aggregate.groupings());
                child = new ExchangeExec(child.source(), output, true, exchange.child());
            } else {
                child = Mapper.aggExec(aggregate, child, AggregateExec.Mode.PARTIAL);
            }
            child = Mapper.aggExec(aggregate, child, AggregateExec.Mode.FINAL);
        }
        return child;
    }

    private static AggregateExec aggExec(Aggregate aggregate, PhysicalPlan child, AggregateExec.Mode aggMode) {
        return new AggregateExec(aggregate.source(), child, aggregate.groupings(), aggregate.aggregates(), aggMode, null);
    }

    private PhysicalPlan map(Limit limit, PhysicalPlan child) {
        child = this.addExchangeForFragment((LogicalPlan)limit, child);
        return new LimitExec(limit.source(), child, limit.limit());
    }

    private PhysicalPlan map(OrderBy o, PhysicalPlan child) {
        child = this.addExchangeForFragment((LogicalPlan)o, child);
        return new OrderExec(o.source(), child, o.order());
    }

    private PhysicalPlan map(TopN topN, PhysicalPlan child) {
        child = this.addExchangeForFragment((LogicalPlan)topN, child);
        return new TopNExec(topN.source(), child, topN.order(), topN.limit(), null);
    }

    private PhysicalPlan addExchangeForFragment(LogicalPlan logical, PhysicalPlan child) {
        if (child instanceof FragmentExec) {
            child = new FragmentExec(logical);
            child = new ExchangeExec(child.source(), child);
        }
        return child;
    }
}

