/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.lucene.LuceneSourceOperator;
import org.elasticsearch.compute.lucene.LuceneTopNSourceOperator;
import org.elasticsearch.compute.lucene.ValueSources;
import org.elasticsearch.compute.lucene.ValuesSourceReaderOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OrdinalsGroupingOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.type.DataType;

public class EsPhysicalOperationProviders
extends AbstractPhysicalOperationProviders {
    private static final Logger logger = LogManager.getLogger(EsPhysicalOperationProviders.class);
    private final List<SearchContext> searchContexts;

    public EsPhysicalOperationProviders(List<SearchContext> searchContexts) {
        this.searchContexts = searchContexts;
    }

    public List<SearchContext> searchContexts() {
        return this.searchContexts;
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation fieldExtractPhysicalOperation(FieldExtractExec fieldExtractExec, LocalExecutionPlanner.PhysicalOperation source) {
        Layout.Builder layout = source.layout.builder();
        Attribute sourceAttr = fieldExtractExec.sourceAttribute();
        LocalExecutionPlanner.PhysicalOperation op = source;
        for (Attribute attr : fieldExtractExec.attributesToExtract()) {
            FieldAttribute fa;
            if (attr instanceof FieldAttribute && (fa = (FieldAttribute)attr).getExactInfo().hasExact()) {
                attr = fa.exactAttribute();
            }
            layout.append((NamedExpression)attr);
            Layout previousLayout = op.layout;
            DataType dataType = attr.dataType();
            String fieldName = attr.name();
            Supplier<List> sources = () -> ValueSources.sources(this.searchContexts, (String)fieldName, (boolean)EsqlDataTypes.isUnsupported(dataType), (ElementType)LocalExecutionPlanner.toElementType(dataType));
            int docChannel = previousLayout.get(sourceAttr.id()).channel();
            op = op.with((Operator.OperatorFactory)new ValuesSourceReaderOperator.ValuesSourceReaderOperatorFactory(sources, docChannel, fieldName), layout.build());
        }
        return op;
    }

    public static Function<SearchContext, Query> querySupplier(QueryBuilder queryBuilder) {
        MatchAllQueryBuilder qb = queryBuilder == null ? QueryBuilders.matchAllQuery() : queryBuilder;
        return arg_0 -> EsPhysicalOperationProviders.lambda$querySupplier$1((QueryBuilder)qb, arg_0);
    }

    @Override
    public final LocalExecutionPlanner.PhysicalOperation sourcePhysicalOperation(EsQueryExec esQueryExec, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        LuceneSourceOperator.Factory luceneFactory;
        int limit;
        Function<SearchContext, Query> querySupplier = EsPhysicalOperationProviders.querySupplier(esQueryExec.query());
        List<EsQueryExec.FieldSort> sorts = esQueryExec.sorts();
        ArrayList<FieldSortBuilder> fieldSorts = null;
        assert (esQueryExec.estimatedRowSize() != null) : "estimated row size not initialized";
        int rowEstimatedSize = esQueryExec.estimatedRowSize();
        int n = limit = esQueryExec.limit() != null ? (Integer)esQueryExec.limit().fold() : Integer.MAX_VALUE;
        if (sorts != null && !sorts.isEmpty()) {
            fieldSorts = new ArrayList<FieldSortBuilder>(sorts.size());
            for (EsQueryExec.FieldSort sort : sorts) {
                fieldSorts.add(sort.fieldSortBuilder());
            }
            luceneFactory = new LuceneTopNSourceOperator.Factory(this.searchContexts, querySupplier, context.queryPragmas().dataPartitioning(), context.queryPragmas().taskConcurrency(), context.pageSize(rowEstimatedSize), limit, fieldSorts);
        } else {
            luceneFactory = new LuceneSourceOperator.Factory(this.searchContexts, querySupplier, context.queryPragmas().dataPartitioning(), context.queryPragmas().taskConcurrency(), context.pageSize(rowEstimatedSize), limit);
        }
        Layout.Builder layout = new Layout.Builder();
        layout.append(esQueryExec.output());
        int instanceCount = Math.max(1, luceneFactory.taskConcurrency());
        context.driverParallelism(new LocalExecutionPlanner.DriverParallelism(LocalExecutionPlanner.DriverParallelism.Type.DATA_PARALLELISM, instanceCount));
        return LocalExecutionPlanner.PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)luceneFactory, layout.build());
    }

    @Override
    public final Operator.OperatorFactory ordinalGroupingOperatorFactory(LocalExecutionPlanner.PhysicalOperation source, AggregateExec aggregateExec, List<GroupingAggregator.Factory> aggregatorFactories, Attribute attrSource, ElementType groupElementType, LocalExecutionPlanner.LocalExecutionPlannerContext context) {
        Attribute sourceAttribute = FieldExtractExec.extractSourceAttributesFrom(aggregateExec.child());
        int docChannel = source.layout.get(sourceAttribute.id()).channel();
        return new OrdinalsGroupingOperator.OrdinalsGroupingOperatorFactory(() -> ValueSources.sources(this.searchContexts, (String)attrSource.name(), (boolean)EsqlDataTypes.isUnsupported(attrSource.dataType()), (ElementType)LocalExecutionPlanner.toElementType(attrSource.dataType())), docChannel, attrSource.name(), aggregatorFactories, context.pageSize(aggregateExec.estimatedRowSize()), context.bigArrays());
    }

    private static /* synthetic */ Query lambda$querySupplier$1(QueryBuilder qb, SearchContext searchContext) {
        AliasFilter aliasFilter;
        SearchExecutionContext ctx = searchContext.getSearchExecutionContext();
        Query query = ctx.toQuery(qb).query();
        NestedLookup nestedLookup = ctx.nestedLookup();
        if (nestedLookup != NestedLookup.EMPTY) {
            NestedHelper nestedHelper = new NestedHelper(nestedLookup, arg_0 -> ((SearchExecutionContext)ctx).isFieldMapped(arg_0));
            if (nestedHelper.mightMatchNestedDocs(query)) {
                query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter((IndexVersion)ctx.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
            }
        }
        if ((aliasFilter = searchContext.request().getAliasFilter()) != AliasFilter.EMPTY) {
            Query filterQuery = ctx.toQuery(aliasFilter.getQueryBuilder()).query();
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(filterQuery, BooleanClause.Occur.FILTER).build();
        }
        return query;
    }
}

