/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;

public class FieldExtractExec
extends UnaryExec
implements EstimatesRowSize {
    private final List<Attribute> attributesToExtract;
    private final Attribute sourceAttribute;

    public FieldExtractExec(Source source, PhysicalPlan child, List<Attribute> attributesToExtract) {
        super(source, child);
        this.attributesToExtract = attributesToExtract;
        this.sourceAttribute = FieldExtractExec.extractSourceAttributesFrom(child);
    }

    public static Attribute extractSourceAttributesFrom(PhysicalPlan plan) {
        return plan.outputSet().stream().filter(EsQueryExec::isSourceAttribute).findFirst().orElse(null);
    }

    protected NodeInfo<FieldExtractExec> info() {
        return NodeInfo.create((Node)this, FieldExtractExec::new, (Object)((Object)this.child()), this.attributesToExtract);
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new FieldExtractExec(this.source(), newChild, this.attributesToExtract);
    }

    public List<Attribute> attributesToExtract() {
        return this.attributesToExtract;
    }

    public Attribute sourceAttribute() {
        return this.sourceAttribute;
    }

    @Override
    public List<Attribute> output() {
        ArrayList<Attribute> output = new ArrayList<Attribute>(this.child().output());
        output.addAll(this.attributesToExtract);
        return output;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(true, this.attributesToExtract);
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.attributesToExtract, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldExtractExec other = (FieldExtractExec)obj;
        return Objects.equals(this.attributesToExtract, other.attributesToExtract) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    public String nodeString() {
        return this.nodeName() + NodeUtils.limitedToString(this.attributesToExtract);
    }
}

