/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public interface EstimatesRowSize {
    public static PhysicalPlan estimateRowSize(int extraRowSize, PhysicalPlan plan) {
        State state = new State();
        state.maxEstimatedRowSize = state.estimatedRowSize = extraRowSize;
        return (PhysicalPlan)plan.transformDown(exec -> {
            if (exec instanceof EstimatesRowSize) {
                EstimatesRowSize r = (EstimatesRowSize)((Object)exec);
                return r.estimateRowSize(state);
            }
            return exec;
        });
    }

    public PhysicalPlan estimateRowSize(State var1);

    public static int estimateSize(DataType dataType) {
        ElementType elementType = LocalExecutionPlanner.toElementType(dataType);
        return switch (elementType) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.BOOLEAN -> 1;
            case ElementType.BYTES_REF -> {
                if (dataType == DataTypes.IP) {
                    yield 16;
                }
                yield 50;
            }
            case ElementType.DOC -> throw new EsqlIllegalArgumentException("can't load a [doc] with field extraction");
            case ElementType.DOUBLE -> 8;
            case ElementType.INT -> 4;
            case ElementType.LONG -> 8;
            case ElementType.NULL -> 0;
            case ElementType.UNKNOWN -> throw new EsqlIllegalArgumentException("[unknown] can't be the result of field extraction");
        };
    }

    public static final class State {
        private int estimatedRowSize;
        private int maxEstimatedRowSize;
        private boolean needsSortedDocIds;

        public void add(boolean needsSortedDocIds, int bytes) {
            this.estimatedRowSize += bytes;
            this.maxEstimatedRowSize = Math.max(this.estimatedRowSize, this.maxEstimatedRowSize);
            this.needsSortedDocIds |= needsSortedDocIds;
        }

        public void add(boolean needsSortedDocIds, List<? extends Expression> expressions) {
            expressions.stream().forEach(a -> this.estimatedRowSize += EstimatesRowSize.estimateSize(a.dataType()));
            this.maxEstimatedRowSize = Math.max(this.estimatedRowSize, this.maxEstimatedRowSize);
            this.needsSortedDocIds |= needsSortedDocIds;
        }

        public int consumeAllFields(boolean producesUnsortedDocIds) {
            int size = this.maxEstimatedRowSize;
            if (producesUnsortedDocIds && this.needsSortedDocIds) {
                size += 8;
            }
            this.maxEstimatedRowSize = 0;
            this.estimatedRowSize = 0;
            this.needsSortedDocIds = false;
            return size;
        }

        public String toString() {
            return "State{estimatedRowSize=" + this.estimatedRowSize + ", maxEstimatedRowSize=" + this.maxEstimatedRowSize + ", needsSortedDocIds=" + this.needsSortedDocIds + "}";
        }
    }
}

