/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class EnrichExec
extends UnaryExec
implements EstimatesRowSize {
    private final NamedExpression matchField;
    private final String policyName;
    private final String policyMatchField;
    private final EsIndex enrichIndex;
    private final List<NamedExpression> enrichFields;

    public EnrichExec(Source source, PhysicalPlan child, NamedExpression matchField, String policyName, String policyMatchField, EsIndex enrichIndex, List<NamedExpression> enrichFields) {
        super(source, child);
        this.matchField = matchField;
        this.policyName = policyName;
        this.policyMatchField = policyMatchField;
        this.enrichIndex = enrichIndex;
        this.enrichFields = enrichFields;
    }

    protected NodeInfo<EnrichExec> info() {
        return NodeInfo.create((Node)this, EnrichExec::new, (Object)((Object)this.child()), (Object)this.matchField, (Object)this.policyName, (Object)this.policyMatchField, (Object)this.enrichIndex, this.enrichFields);
    }

    @Override
    public EnrichExec replaceChild(PhysicalPlan newChild) {
        return new EnrichExec(this.source(), newChild, this.matchField, this.policyName, this.policyMatchField, this.enrichIndex, this.enrichFields);
    }

    public NamedExpression matchField() {
        return this.matchField;
    }

    public EsIndex enrichIndex() {
        return this.enrichIndex;
    }

    public List<NamedExpression> enrichFields() {
        return this.enrichFields;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyMatchField() {
        return this.policyMatchField;
    }

    @Override
    public List<Attribute> output() {
        return NamedExpressions.mergeOutputAttributes(this.enrichFields, this.child().output());
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.enrichFields);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnrichExec that = (EnrichExec)o;
        return Objects.equals(this.matchField, that.matchField) && Objects.equals(this.policyName, that.policyName) && Objects.equals(this.policyMatchField, that.policyMatchField) && Objects.equals(this.enrichIndex, that.enrichIndex) && Objects.equals(this.enrichFields, that.enrichFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.matchField, this.policyName, this.policyMatchField, this.enrichIndex, this.enrichFields);
    }
}

