/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.ExpressionSet;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.rule.ParameterizedRule;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;

public class LogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LogicalOptimizerContext> {
    public LogicalPlanOptimizer(LogicalOptimizerContext optimizerContext) {
        super((Object)optimizerContext);
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        return verified.optimized() ? verified : (LogicalPlan)this.execute((Node)verified);
    }

    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return LogicalPlanOptimizer.rules();
    }

    protected static List<RuleExecutor.Batch<LogicalPlan>> rules() {
        RuleExecutor.Batch substitutions = new RuleExecutor.Batch("Substitutions", RuleExecutor.Limiter.ONCE, new Rule[]{new SubstituteSurrogates(), new ReplaceRegexMatch(), new ReplaceAliasingEvalWithProject()});
        RuleExecutor.Batch operators = new RuleExecutor.Batch("Operator Optimization", new Rule[]{new CombineProjections(), new CombineEvals(), new PruneEmptyPlans(), new PropagateEmptyRelation(), new ConvertStringToByteRef(), new OptimizerRules.FoldNull(), new SplitInWithFoldableValue(), new OptimizerRules.ConstantFolding(), new PropagateEvalFoldables(), new BooleanSimplification(), new OptimizerRules.LiteralsOnTheRight(), new OptimizerRules.BinaryComparisonSimplification(), new OptimizerRules.PropagateEquals(), new OptimizerRules.PropagateNullable(), new OptimizerRules.BooleanFunctionEqualsElimination(), new CombineDisjunctionsToIn(), new OptimizerRules.SimplifyComparisonsArithmetics(EsqlDataTypes::areCompatible), new PruneFilters(), new PruneColumns(), new OptimizerRules.PruneLiteralsInOrderBy(), new PushDownAndCombineLimits(), new DuplicateLimitAfterMvExpand(), new PushDownAndCombineFilters(), new PushDownEval(), new PushDownRegexExtract(), new PushDownEnrich(), new PushDownAndCombineOrderBy(), new PruneOrderByBeforeStats(), new PruneRedundantSortClauses()});
        RuleExecutor.Batch skip = new RuleExecutor.Batch("Skip Compute", new Rule[]{new SkipQueryOnLimitZero()});
        RuleExecutor.Batch cleanup = new RuleExecutor.Batch("Clean Up", new Rule[]{new ReplaceLimitAndSortAsTopN()});
        RuleExecutor.Batch defaultTopN = new RuleExecutor.Batch("Add default TopN", new Rule[]{new AddDefaultTopN()});
        RuleExecutor.Batch label = new RuleExecutor.Batch("Set as Optimized", RuleExecutor.Limiter.ONCE, new Rule[]{new OptimizerRules.SetAsOptimized()});
        return Arrays.asList(substitutions, operators, skip, cleanup, defaultTopN, label);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan) {
        return new LocalRelation(plan.source(), plan.output(), LocalSupplier.EMPTY);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan, LocalSupplier supplier) {
        return new LocalRelation(plan.source(), plan.output(), supplier);
    }

    private static Project pushDownPastProject(UnaryPlan parent) {
        LogicalPlan logicalPlan = parent.child();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            AttributeMap.Builder aliasBuilder = AttributeMap.builder();
            project.forEachExpression(Alias.class, a -> aliasBuilder.put(a.toAttribute(), (Object)a.child()));
            AttributeMap aliases = aliasBuilder.build();
            UnaryPlan expressionsWithResolvedAliases = (UnaryPlan)parent.transformExpressionsOnly(ReferenceAttribute.class, r -> (Expression)aliases.resolve(r, r));
            return project.replaceChild((LogicalPlan)expressionsWithResolvedAliases.replaceChild(project.child()));
        }
        throw new EsqlIllegalArgumentException("Expected child to be instance of Project");
    }

    static class SubstituteSurrogates
    extends OptimizerRules.OptimizerRule<Aggregate> {
        SubstituteSurrogates() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(Aggregate aggregate) {
            List aggs = aggregate.aggregates();
            ArrayList<NamedExpression> newAggs = new ArrayList<NamedExpression>(aggs.size());
            HashMap<AggregateFunction, Attribute> aggFuncToAttr = new HashMap<AggregateFunction, Attribute>();
            ArrayList<Alias> transientEval = new ArrayList<Alias>();
            boolean changed = false;
            for (NamedExpression agg : aggs) {
                AggregateFunction af2;
                Alias a;
                Expression expression;
                if (!(agg instanceof Alias) || !((expression = (a = (Alias)agg).child()) instanceof AggregateFunction) || (af2 = (AggregateFunction)expression) instanceof SurrogateExpression) continue;
                aggFuncToAttr.put(af2, a.toAttribute());
            }
            for (NamedExpression agg : aggs) {
                NamedExpression e;
                if (agg instanceof Alias) {
                    Alias a = (Alias)agg;
                    v0 = a.child();
                } else {
                    v0 = e = agg;
                }
                if (e instanceof SurrogateExpression) {
                    SurrogateExpression sf = (SurrogateExpression)e;
                    changed = true;
                    Expression s = sf.surrogate();
                    if (!(s instanceof AggregateFunction)) {
                        Expression surrogateWithRefs = (Expression)s.transformUp(AggregateFunction.class, af -> {
                            Attribute attr = (Attribute)aggFuncToAttr.get(af);
                            if (attr == null) {
                                String temporaryName = SubstituteSurrogates.temporaryName(agg, af);
                                Alias newAlias = new Alias(agg.source(), temporaryName, null, (Expression)af, null, true);
                                attr = newAlias.toAttribute();
                                aggFuncToAttr.put((AggregateFunction)af, attr);
                                newAggs.add((NamedExpression)newAlias);
                            }
                            return attr;
                        });
                        Alias aliased = new Alias(agg.source(), agg.name(), null, surrogateWithRefs, agg.toAttribute().id());
                        transientEval.add(aliased);
                        continue;
                    }
                    newAggs.add((NamedExpression)agg.replaceChildren(Collections.singletonList(s)));
                    continue;
                }
                newAggs.add(agg);
            }
            Object plan = aggregate;
            if (changed) {
                Source source = aggregate.source();
                plan = new Aggregate(aggregate.source(), aggregate.child(), aggregate.groupings(), newAggs);
                if (transientEval.size() > 0) {
                    plan = new Eval(source, (LogicalPlan)plan, transientEval);
                    plan = new EsqlProject(source, (LogicalPlan)plan, Expressions.asAttributes((List)aggs));
                }
            }
            return plan;
        }

        private static String temporaryName(NamedExpression agg, AggregateFunction af) {
            return "__" + agg.name() + "_" + af.functionName() + "@" + Integer.toHexString(af.hashCode());
        }
    }

    public static class ReplaceRegexMatch
    extends OptimizerRules.ReplaceRegexMatch {
        protected Expression regexToEquals(RegexMatch<?> regexMatch, Literal literal) {
            return new Equals(regexMatch.source(), regexMatch.field(), (Expression)literal);
        }
    }

    static class ReplaceAliasingEvalWithProject
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceAliasingEvalWithProject() {
        }

        public LogicalPlan apply(LogicalPlan logicalPlan) {
            Holder enabled = new Holder((Object)false);
            return (LogicalPlan)logicalPlan.transformDown(p -> {
                if (p instanceof Aggregate || p instanceof Project) {
                    enabled.set((Object)true);
                } else if (((Boolean)enabled.get()).booleanValue() && p instanceof Eval) {
                    Eval eval = (Eval)((Object)p);
                    p = this.rule(eval);
                }
                return p;
            });
        }

        private LogicalPlan rule(Eval eval) {
            Eval plan = eval;
            AttributeMap basicAliases = new AttributeMap();
            AttributeMap basicAliasSources = new AttributeMap();
            ArrayList<Alias> keptFields = new ArrayList<Alias>();
            List<Alias> fields = eval.fields();
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                Alias field = fields.get(i);
                Expression child = field.child();
                Attribute attribute = field.toAttribute();
                if (child instanceof Attribute) {
                    basicAliases.put(attribute, (Object)child);
                    basicAliasSources.put(attribute, (Object)field);
                    continue;
                }
                if (basicAliases.size() > 0) {
                    field = (Alias)field.transformUp(e -> (Expression)basicAliases.resolve(e, e));
                }
                keptFields.add(field);
            }
            if (basicAliases.size() > 0) {
                ArrayList<Attribute> projections = new ArrayList<Attribute>(eval.output());
                for (int i = projections.size() - 1; i >= 0; --i) {
                    NamedExpression project = (NamedExpression)projections.get(i);
                    projections.set(i, (Attribute)((NamedExpression)basicAliasSources.getOrDefault((Object)project, (Object)project)));
                }
                Object child = eval.child();
                if (keptFields.size() > 0) {
                    child = new Eval(eval.source(), eval.child(), keptFields);
                }
                plan = new Project(eval.source(), child, projections);
            }
            return plan;
        }
    }

    static class CombineProjections
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        CombineProjections() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            LogicalPlan child = plan.child();
            if (plan instanceof Project) {
                Project project = (Project)plan;
                if (child instanceof Project) {
                    Project p = (Project)child;
                    return p.withProjections(this.combineProjections(project.projections(), p.projections()));
                }
                if (child instanceof Aggregate) {
                    Aggregate a = (Aggregate)child;
                    List aggs = a.aggregates();
                    List<NamedExpression> newAggs = this.combineProjections(project.projections(), aggs);
                    List<Expression> newGroups = this.replacePrunedAliasesUsedInGroupBy(a.groupings(), aggs, newAggs);
                    return new Aggregate(a.source(), a.child(), newGroups, newAggs);
                }
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (child instanceof Project) {
                    Project p = (Project)child;
                    return new Aggregate(a.source(), p.child(), a.groupings(), this.combineProjections(a.aggregates(), p.projections()));
                }
            }
            return plan;
        }

        private List<NamedExpression> combineProjections(List<? extends NamedExpression> upper, List<? extends NamedExpression> lower) {
            AttributeMap.Builder aliasesBuilder = AttributeMap.builder();
            for (NamedExpression namedExpression : lower) {
                if (namedExpression instanceof Attribute) continue;
                aliasesBuilder.put(namedExpression.toAttribute(), (Object)namedExpression);
            }
            AttributeMap aliases = aliasesBuilder.build();
            ArrayList<NamedExpression> arrayList = new ArrayList<NamedExpression>();
            for (NamedExpression namedExpression : upper) {
                NamedExpression replacedExp = (NamedExpression)namedExpression.transformUp(Attribute.class, a -> (Expression)aliases.resolve(a, a));
                arrayList.add((NamedExpression)CombineProjections.trimNonTopLevelAliases((Expression)replacedExp));
            }
            return arrayList;
        }

        private List<Expression> replacePrunedAliasesUsedInGroupBy(List<Expression> groupings, List<? extends NamedExpression> oldAggs, List<? extends NamedExpression> newAggs) {
            AttributeMap removedAliases = new AttributeMap();
            AttributeSet currentAliases = new AttributeSet((Collection)Expressions.asAttributes(newAggs));
            for (NamedExpression namedExpression : oldAggs) {
                if (!(namedExpression instanceof Alias)) continue;
                Alias alias = (Alias)namedExpression;
                Attribute attr = namedExpression.toAttribute();
                if (currentAliases.contains((Object)attr)) continue;
                removedAliases.put(attr, (Object)alias.child());
            }
            if (removedAliases.isEmpty()) {
                return groupings;
            }
            ArrayList<Expression> newGroupings = new ArrayList<Expression>(groupings.size());
            for (Expression group : groupings) {
                newGroupings.add((Expression)group.transformUp(Attribute.class, a -> (Expression)removedAliases.resolve(a, a)));
            }
            return newGroupings;
        }

        public static Expression trimNonTopLevelAliases(Expression e) {
            if (e instanceof Alias) {
                Alias a = (Alias)e;
                return new Alias(a.source(), a.name(), a.qualifier(), CombineProjections.trimAliases(a.child()), a.id());
            }
            return CombineProjections.trimAliases(e);
        }

        private static Expression trimAliases(Expression e) {
            return (Expression)e.transformDown(Alias.class, Alias::child);
        }
    }

    static class CombineEvals
    extends OptimizerRules.OptimizerRule<Eval> {
        CombineEvals() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(Eval eval) {
            Eval plan = eval;
            LogicalPlan logicalPlan = eval.child();
            if (logicalPlan instanceof Eval) {
                Eval subEval = (Eval)logicalPlan;
                plan = new Eval(eval.source(), subEval.child(), CollectionUtils.combine(subEval.fields(), eval.fields()));
            }
            return plan;
        }
    }

    static class PruneEmptyPlans
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        PruneEmptyPlans() {
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            return plan.output().isEmpty() ? LogicalPlanOptimizer.skipPlan(plan) : plan;
        }
    }

    static class PropagateEmptyRelation
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        PropagateEmptyRelation() {
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            LocalRelation local;
            UnaryPlan p = plan;
            LogicalPlan logicalPlan = plan.child();
            if (logicalPlan instanceof LocalRelation && (local = (LocalRelation)logicalPlan).supplier() == LocalSupplier.EMPTY) {
                Aggregate agg;
                if (plan instanceof Aggregate && (agg = (Aggregate)plan).groupings().isEmpty()) {
                    List<Block> emptyBlocks = PropagateEmptyRelation.aggsFromEmpty(agg.aggregates());
                    p = LogicalPlanOptimizer.skipPlan(plan, LocalSupplier.of((Block[])emptyBlocks.toArray(Block[]::new)));
                } else {
                    p = LogicalPlanOptimizer.skipPlan(plan);
                }
            }
            return p;
        }

        private static List<Block> aggsFromEmpty(List<? extends NamedExpression> aggs) {
            ArrayList<Block> blocks = new ArrayList<Block>();
            BlockFactory blockFactory = BlockFactory.getNonBreakingInstance();
            boolean i = false;
            for (NamedExpression namedExpression : aggs) {
                Alias a;
                Expression expression;
                if (namedExpression instanceof Alias && (expression = (a = (Alias)namedExpression).child()) instanceof AggregateFunction) {
                    AggregateFunction aggFunc = (AggregateFunction)expression;
                    List<Attribute> output = AbstractPhysicalOperationProviders.intermediateAttributes(List.of(namedExpression), List.of());
                    for (Attribute o : output) {
                        Count count;
                        DataType dataType = o.dataType();
                        if (dataType == DataTypes.BOOLEAN) continue;
                        BlockUtils.BuilderWrapper wrapper = BlockUtils.wrapperFor((BlockFactory)blockFactory, (ElementType)LocalExecutionPlanner.toElementType(dataType), (int)1);
                        if (aggFunc instanceof Count && (!(count = (Count)aggFunc).foldable() || count.fold() != null)) {
                            wrapper.accept((Object)0L);
                        } else {
                            wrapper.accept(null);
                        }
                        blocks.add(wrapper.builder().build());
                    }
                    continue;
                }
                throw new EsqlIllegalArgumentException("Did not expect a non-aliased aggregation {}", namedExpression);
            }
            return blocks;
        }
    }

    static class ConvertStringToByteRef
    extends OptimizerRules.OptimizerExpressionRule<Literal> {
        ConvertStringToByteRef() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected Expression rule(Literal lit) {
            if (lit.value() == null) {
                return lit;
            }
            Object object = lit.value();
            if (object instanceof String) {
                String s = (String)object;
                return Literal.of((Expression)lit, (Object)new BytesRef((CharSequence)s));
            }
            object = lit.value();
            if (object instanceof List) {
                List l = (List)object;
                if (l.isEmpty() || !(l.get(0) instanceof String)) {
                    return lit;
                }
                return Literal.of((Expression)lit, l.stream().map(v -> new BytesRef((CharSequence)((String)v))).toList());
            }
            return lit;
        }
    }

    public static class SplitInWithFoldableValue
    extends OptimizerRules.OptimizerExpressionRule<In> {
        SplitInWithFoldableValue() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected Expression rule(In in) {
            if (in.value().foldable()) {
                ArrayList<Expression> foldables = new ArrayList<Expression>(in.list().size());
                ArrayList<Expression> nonFoldables = new ArrayList<Expression>(in.list().size());
                in.list().forEach(e -> {
                    if (e.foldable() && !Expressions.isNull((Expression)e)) {
                        foldables.add((Expression)e);
                    } else {
                        nonFoldables.add((Expression)e);
                    }
                });
                if (foldables.size() > 0 && nonFoldables.size() > 0) {
                    In withFoldables = new In(in.source(), in.value(), foldables);
                    In withoutFoldables = new In(in.source(), in.value(), nonFoldables);
                    return new Or(in.source(), (Expression)withFoldables, (Expression)withoutFoldables);
                }
            }
            return in;
        }
    }

    static class PropagateEvalFoldables
    extends Rule<LogicalPlan, LogicalPlan> {
        PropagateEvalFoldables() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            AttributeMap collectRefs = new AttributeMap();
            plan.forEachExpressionUp(Alias.class, a -> {
                Expression c = a.child();
                if (c.foldable()) {
                    collectRefs.put(a.toAttribute(), (Object)c);
                }
            });
            if (collectRefs.isEmpty()) {
                return plan;
            }
            Function<ReferenceAttribute, Expression> replaceReference = r -> (Expression)collectRefs.resolve(r, r);
            plan = (LogicalPlan)plan.transformUp(p -> {
                if (p instanceof Filter || p instanceof Eval) {
                    p = (LogicalPlan)p.transformExpressionsOnly(ReferenceAttribute.class, replaceReference);
                }
                return p;
            });
            return plan;
        }
    }

    private static class BooleanSimplification
    extends OptimizerRules.BooleanSimplification {
        BooleanSimplification() {
        }

        protected Expression maybeSimplifyNegatable(Expression e) {
            return null;
        }
    }

    public static class CombineDisjunctionsToIn
    extends OptimizerRules.CombineDisjunctionsToIn {
        protected In createIn(Expression key, List<Expression> values, ZoneId zoneId) {
            return new In(key.source(), key, values);
        }

        protected Equals createEquals(Expression k, Set<Expression> v, ZoneId finalZoneId) {
            return new Equals(k.source(), k, v.iterator().next(), finalZoneId);
        }
    }

    static class PruneFilters
    extends OptimizerRules.PruneFilters {
        PruneFilters() {
        }

        protected LogicalPlan skipPlan(Filter filter) {
            return LogicalPlanOptimizer.skipPlan((UnaryPlan)filter);
        }
    }

    static class PruneColumns
    extends Rule<LogicalPlan, LogicalPlan> {
        PruneColumns() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            AttributeSet used = new AttributeSet();
            Holder seenProjection = new Holder((Object)Boolean.FALSE);
            LogicalPlan pl = (LogicalPlan)plan.transformDown(p -> {
                boolean recheck;
                if (p instanceof Limit) {
                    return p;
                }
                do {
                    List<Alias> remaining;
                    recheck = false;
                    if (p instanceof Aggregate) {
                        Aggregate aggregate = (Aggregate)p;
                        List<Alias> list = remaining = (Boolean)seenProjection.get() != false ? PruneColumns.removeUnused(aggregate.aggregates(), used) : null;
                        if (remaining != null) {
                            if (remaining.isEmpty()) {
                                recheck = true;
                                p = aggregate.child();
                            } else {
                                p = new Aggregate(aggregate.source(), aggregate.child(), aggregate.groupings(), remaining);
                            }
                        }
                        seenProjection.set((Object)Boolean.TRUE);
                        continue;
                    }
                    if (p instanceof Eval) {
                        Eval eval = (Eval)((Object)((Object)p));
                        List<Alias> list = remaining = (Boolean)seenProjection.get() != false ? PruneColumns.removeUnused(eval.fields(), used) : null;
                        if (remaining == null) continue;
                        if (remaining.isEmpty()) {
                            p = eval.child();
                            recheck = true;
                            continue;
                        }
                        p = new Eval(eval.source(), eval.child(), remaining);
                        continue;
                    }
                    if (!(p instanceof Project)) continue;
                    seenProjection.set((Object)Boolean.TRUE);
                } while (recheck);
                used.addAll(p.references());
                return p;
            });
            return pl;
        }

        private static <N extends NamedExpression> List<N> removeUnused(List<N> named, AttributeSet used) {
            ArrayList<N> clone = new ArrayList<N>(named);
            ListIterator<N> it = clone.listIterator(clone.size());
            while (it.hasPrevious()) {
                NamedExpression prev = (NamedExpression)it.previous();
                if (!used.contains((Object)prev.toAttribute())) {
                    it.remove();
                    continue;
                }
                used.addAll(prev.references());
            }
            return clone.size() != named.size() ? clone : null;
        }
    }

    static class PushDownAndCombineLimits
    extends OptimizerRules.OptimizerRule<Limit> {
        PushDownAndCombineLimits() {
        }

        protected LogicalPlan rule(Limit limit) {
            LogicalPlan limitSource;
            LogicalPlan logicalPlan = limit.child();
            if (logicalPlan instanceof Limit) {
                Limit childLimit = (Limit)logicalPlan;
                limitSource = limit.limit();
                int l1 = (Integer)limitSource.fold();
                int l2 = (Integer)childLimit.limit().fold();
                return new Limit(limit.source(), (Expression)Literal.of((Expression)limitSource, (Object)Math.min(l1, l2)), childLimit.child());
            }
            limitSource = limit.child();
            if (limitSource instanceof UnaryPlan) {
                UnaryPlan unary = (UnaryPlan)limitSource;
                if (unary instanceof Eval || unary instanceof Project || unary instanceof RegexExtract || unary instanceof Enrich) {
                    return unary.replaceChild((LogicalPlan)limit.replaceChild(unary.child()));
                }
                Limit descendantLimit = PushDownAndCombineLimits.descendantLimit(unary);
                if (descendantLimit != null) {
                    int l1 = (Integer)limit.limit().fold();
                    int l2 = (Integer)descendantLimit.limit().fold();
                    if (l2 <= l1) {
                        return new Limit(limit.source(), (Expression)Literal.of((Expression)limit.limit(), (Object)l2), limit.child());
                    }
                }
            }
            return limit;
        }

        private static Limit descendantLimit(UnaryPlan unary) {
            UnaryPlan plan = unary;
            while (!(plan instanceof Aggregate)) {
                UnaryPlan unaryPlan;
                if (plan instanceof Limit) {
                    Limit limit = (Limit)plan;
                    return limit;
                }
                if (plan instanceof MvExpand) {
                    return null;
                }
                LogicalPlan logicalPlan = plan.child();
                if (!(logicalPlan instanceof UnaryPlan)) break;
                plan = unaryPlan = (UnaryPlan)logicalPlan;
            }
            return null;
        }
    }

    static class DuplicateLimitAfterMvExpand
    extends OptimizerRules.OptimizerRule<Limit> {
        DuplicateLimitAfterMvExpand() {
        }

        protected LogicalPlan rule(Limit limit) {
            Limit limitBeforeMvExpand;
            UnaryPlan unary;
            MvExpand mvExpand;
            boolean shouldSkip;
            LogicalPlan child = limit.child();
            boolean bl = shouldSkip = child instanceof Eval || child instanceof Project || child instanceof RegexExtract || child instanceof Enrich || child instanceof Limit;
            if (!shouldSkip && child instanceof UnaryPlan && (mvExpand = DuplicateLimitAfterMvExpand.descendantMvExpand(unary = (UnaryPlan)child)) != null && (limitBeforeMvExpand = DuplicateLimitAfterMvExpand.limitBeforeMvExpand(mvExpand)) == null) {
                Limit duplicateLimit = new Limit(limit.source(), limit.limit(), mvExpand.child());
                return limit.replaceChild(this.propagateDuplicateLimitUntilMvExpand(duplicateLimit, mvExpand, unary));
            }
            return limit;
        }

        private static MvExpand descendantMvExpand(UnaryPlan unary) {
            UnaryPlan plan = unary;
            AttributeSet filterReferences = new AttributeSet();
            while (!(plan instanceof Aggregate)) {
                UnaryPlan unaryPlan;
                if (plan instanceof MvExpand) {
                    MvExpand mve = (MvExpand)plan;
                    if (!filterReferences.isEmpty() && (filterReferences.contains((Object)mve.target()) || mve.target() instanceof ReferenceAttribute || filterReferences.stream().anyMatch(ref -> ref instanceof ReferenceAttribute))) {
                        return null;
                    }
                    return mve;
                }
                if (plan instanceof Filter) {
                    Filter filter = (Filter)plan;
                    filterReferences.addAll(filter.references());
                } else if (plan instanceof OrderBy) {
                    return null;
                }
                LogicalPlan logicalPlan = plan.child();
                if (!(logicalPlan instanceof UnaryPlan)) break;
                plan = unaryPlan = (UnaryPlan)logicalPlan;
            }
            return null;
        }

        private static Limit limitBeforeMvExpand(MvExpand mvExpand) {
            MvExpand plan = mvExpand;
            while (!(plan instanceof Aggregate)) {
                if (plan instanceof Limit) {
                    Limit limit = (Limit)plan;
                    return limit;
                }
                LogicalPlan logicalPlan = plan.child();
                if (!(logicalPlan instanceof UnaryPlan)) break;
                UnaryPlan unaryPlan = (UnaryPlan)logicalPlan;
                plan = unaryPlan;
            }
            return null;
        }

        private LogicalPlan propagateDuplicateLimitUntilMvExpand(Limit duplicateLimit, MvExpand mvExpand, UnaryPlan child) {
            if (child == mvExpand) {
                return mvExpand.replaceChild((LogicalPlan)duplicateLimit);
            }
            return child.replaceChild(this.propagateDuplicateLimitUntilMvExpand(duplicateLimit, mvExpand, (UnaryPlan)child.child()));
        }
    }

    protected static class PushDownAndCombineFilters
    extends OptimizerRules.OptimizerRule<Filter> {
        protected PushDownAndCombineFilters() {
        }

        protected LogicalPlan rule(Filter filter) {
            Filter plan = filter;
            LogicalPlan child = filter.child();
            Expression condition = filter.condition();
            if (child instanceof Filter) {
                Filter f = (Filter)child;
                plan = f.with(Predicates.combineAnd(List.of(f.condition(), condition)));
            } else if (child instanceof Aggregate) {
                Aggregate agg = (Aggregate)child;
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, (UnaryPlan)agg, e -> e instanceof Attribute && agg.output().contains(e) && !agg.groupings().contains(e) || e instanceof AggregateFunction);
            } else if (child instanceof Eval) {
                Eval eval = (Eval)child;
                AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(eval.fields()));
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, eval, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
            } else if (child instanceof RegexExtract) {
                RegexExtract re = (RegexExtract)child;
                AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(re.extractedFields()));
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, re, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
            } else if (child instanceof Enrich) {
                Enrich enrich = (Enrich)child;
                AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(enrich.enrichFields()));
                plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, enrich, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
            } else {
                if (child instanceof Project) {
                    return LogicalPlanOptimizer.pushDownPastProject((UnaryPlan)filter);
                }
                if (child instanceof OrderBy) {
                    OrderBy orderBy = (OrderBy)child;
                    plan = orderBy.replaceChild((LogicalPlan)filter.with(orderBy.child(), condition));
                }
            }
            return plan;
        }

        private static LogicalPlan maybePushDownPastUnary(Filter filter, UnaryPlan unary, Predicate<Expression> cannotPush) {
            Filter plan;
            ArrayList pushable = new ArrayList();
            ArrayList<Expression> nonPushable = new ArrayList<Expression>();
            for (Expression exp : Predicates.splitAnd((Expression)filter.condition())) {
                (exp.anyMatch(cannotPush) ? nonPushable : pushable).add(exp);
            }
            if (pushable.size() > 0) {
                if (nonPushable.size() > 0) {
                    Filter pushed = new Filter(filter.source(), unary.child(), Predicates.combineAnd(pushable));
                    plan = filter.with((LogicalPlan)unary.replaceChild((LogicalPlan)pushed), Predicates.combineAnd(nonPushable));
                } else {
                    plan = unary.replaceChild((LogicalPlan)filter.with(unary.child(), filter.condition()));
                }
            } else {
                plan = filter;
            }
            return plan;
        }
    }

    protected static class PushDownEval
    extends OptimizerRules.OptimizerRule<Eval> {
        protected PushDownEval() {
        }

        protected LogicalPlan rule(Eval eval) {
            LogicalPlan child = eval.child();
            if (child instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)child;
                return orderBy.replaceChild((LogicalPlan)eval.replaceChild(orderBy.child()));
            }
            if (child instanceof Project) {
                Project projectWithEvalChild = LogicalPlanOptimizer.pushDownPastProject(eval);
                List fieldProjections = Expressions.asAttributes(eval.fields());
                return projectWithEvalChild.withProjections(NamedExpressions.mergeOutputExpressions(fieldProjections, projectWithEvalChild.projections()));
            }
            return eval;
        }
    }

    protected static class PushDownRegexExtract
    extends OptimizerRules.OptimizerRule<RegexExtract> {
        protected PushDownRegexExtract() {
        }

        protected LogicalPlan rule(RegexExtract re) {
            LogicalPlan child = re.child();
            if (child instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)child;
                return orderBy.replaceChild((LogicalPlan)re.replaceChild(orderBy.child()));
            }
            if (child instanceof Project) {
                Project projectWithChild = LogicalPlanOptimizer.pushDownPastProject(re);
                return projectWithChild.withProjections(NamedExpressions.mergeOutputExpressions(re.extractedFields(), projectWithChild.projections()));
            }
            return re;
        }
    }

    protected static class PushDownEnrich
    extends OptimizerRules.OptimizerRule<Enrich> {
        protected PushDownEnrich() {
        }

        protected LogicalPlan rule(Enrich re) {
            LogicalPlan child = re.child();
            if (child instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)child;
                return orderBy.replaceChild((LogicalPlan)re.replaceChild(orderBy.child()));
            }
            if (child instanceof Project) {
                Project projectWithChild = LogicalPlanOptimizer.pushDownPastProject(re);
                List attrs = Expressions.asAttributes(re.enrichFields());
                return projectWithChild.withProjections(NamedExpressions.mergeOutputExpressions(attrs, projectWithChild.projections()));
            }
            return re;
        }
    }

    protected static class PushDownAndCombineOrderBy
    extends OptimizerRules.OptimizerRule<OrderBy> {
        protected PushDownAndCombineOrderBy() {
        }

        protected LogicalPlan rule(OrderBy orderBy) {
            LogicalPlan child = orderBy.child();
            if (child instanceof OrderBy) {
                OrderBy childOrder = (OrderBy)child;
                return new OrderBy(orderBy.source(), childOrder.child(), orderBy.order());
            }
            if (child instanceof Project) {
                return LogicalPlanOptimizer.pushDownPastProject((UnaryPlan)orderBy);
            }
            return orderBy;
        }
    }

    static class PruneOrderByBeforeStats
    extends OptimizerRules.OptimizerRule<Aggregate> {
        PruneOrderByBeforeStats() {
        }

        protected LogicalPlan rule(Aggregate agg) {
            OrderBy order = PruneOrderByBeforeStats.findPullableOrderBy(agg.child());
            Aggregate p = agg;
            if (order != null) {
                p = (LogicalPlan)agg.transformDown(OrderBy.class, o -> o == order ? order.child() : o);
            }
            return p;
        }

        private static OrderBy findPullableOrderBy(LogicalPlan plan) {
            OrderBy pullable = null;
            if (plan instanceof OrderBy) {
                OrderBy o;
                pullable = o = (OrderBy)plan;
            } else if (plan instanceof Eval || plan instanceof Filter || plan instanceof Project || plan instanceof RegexExtract || plan instanceof Enrich) {
                pullable = PruneOrderByBeforeStats.findPullableOrderBy(((UnaryPlan)plan).child());
            }
            return pullable;
        }
    }

    static class PruneRedundantSortClauses
    extends OptimizerRules.OptimizerRule<OrderBy> {
        PruneRedundantSortClauses() {
        }

        protected LogicalPlan rule(OrderBy plan) {
            ExpressionSet referencedAttributes = new ExpressionSet();
            ArrayList<Order> order = new ArrayList<Order>();
            for (Order o : plan.order()) {
                if (!referencedAttributes.add((Expression)o)) continue;
                order.add(o);
            }
            return plan.order().size() == order.size() ? plan : new OrderBy(plan.source(), plan.child(), order);
        }
    }

    static class SkipQueryOnLimitZero
    extends OptimizerRules.SkipQueryOnLimitZero {
        SkipQueryOnLimitZero() {
        }

        protected LogicalPlan skipPlan(Limit limit) {
            return LogicalPlanOptimizer.skipPlan((UnaryPlan)limit);
        }
    }

    static class ReplaceLimitAndSortAsTopN
    extends OptimizerRules.OptimizerRule<Limit> {
        ReplaceLimitAndSortAsTopN() {
        }

        protected LogicalPlan rule(Limit plan) {
            Object p = plan;
            LogicalPlan logicalPlan = plan.child();
            if (logicalPlan instanceof OrderBy) {
                OrderBy o = (OrderBy)logicalPlan;
                p = new TopN(plan.source(), o.child(), o.order(), plan.limit());
            }
            return p;
        }
    }

    static class AddDefaultTopN
    extends ParameterizedOptimizerRule<LogicalPlan, LogicalOptimizerContext> {
        AddDefaultTopN() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan, LogicalOptimizerContext context) {
            OrderBy order;
            UnaryPlan unary;
            LogicalPlan logicalPlan;
            if (plan instanceof UnaryPlan && (logicalPlan = (unary = (UnaryPlan)plan).child()) instanceof OrderBy && (logicalPlan = (order = (OrderBy)logicalPlan).child()) instanceof EsRelation) {
                EsRelation relation = (EsRelation)logicalPlan;
                Literal limit = new Literal(Source.EMPTY, (Object)context.configuration().resultTruncationMaxSize(), DataTypes.INTEGER);
                return unary.replaceChild((LogicalPlan)new TopN(plan.source(), (LogicalPlan)relation, order.order(), (Expression)limit));
            }
            return plan;
        }
    }

    private static abstract class ParameterizedOptimizerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        private ParameterizedOptimizerRule() {
        }

        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return (LogicalPlan)plan.transformDown(this.typeToken(), t -> this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);
    }
}

