/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.stats.SearchStats;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.rule.ParameterizedRule;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;

public class LocalLogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LocalLogicalOptimizerContext> {
    public LocalLogicalPlanOptimizer(LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        super((Object)localLogicalOptimizerContext);
    }

    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        RuleExecutor.Batch local = new RuleExecutor.Batch("Local rewrite", new Rule[]{new ReplaceTopNWithLimitAndSort(), new ReplaceMissingFieldWithNull()});
        ArrayList<RuleExecutor.Batch<LogicalPlan>> rules = new ArrayList<RuleExecutor.Batch<LogicalPlan>>();
        rules.add(local);
        rules.addAll(LogicalPlanOptimizer.rules());
        return rules;
    }

    public LogicalPlan localOptimize(LogicalPlan plan) {
        return (LogicalPlan)this.execute((Node)plan);
    }

    public static class ReplaceTopNWithLimitAndSort
    extends OptimizerRules.OptimizerRule<TopN> {
        public ReplaceTopNWithLimitAndSort() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(TopN plan) {
            return new Limit(plan.source(), plan.limit(), (LogicalPlan)new OrderBy(plan.source(), plan.child(), plan.order()));
        }
    }

    private static class ReplaceMissingFieldWithNull
    extends ParameterizedRule<LogicalPlan, LogicalPlan, LocalLogicalOptimizerContext> {
        private ReplaceMissingFieldWithNull() {
        }

        public LogicalPlan apply(LogicalPlan plan, LocalLogicalOptimizerContext localLogicalOptimizerContext) {
            return (LogicalPlan)plan.transformUp(p -> this.missingToNull((LogicalPlan)p, localLogicalOptimizerContext.searchStats()));
        }

        private LogicalPlan missingToNull(LogicalPlan plan, SearchStats stats) {
            if (plan instanceof EsRelation) {
                return plan;
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                return a;
            }
            if (plan instanceof Project) {
                Project project = (Project)plan;
                List projections = project.projections();
                ArrayList<Object> newProjections = new ArrayList<Object>(projections.size());
                ArrayList<Alias> literals = new ArrayList<Alias>();
                for (NamedExpression projection : projections) {
                    FieldAttribute f2;
                    if (projection instanceof FieldAttribute && !stats.exists((f2 = (FieldAttribute)projection).qualifiedName())) {
                        Alias alias = new Alias(f2.source(), f2.name(), null, (Expression)Literal.of((Expression)f2, null), f2.id());
                        literals.add(alias);
                        newProjections.add(alias.toAttribute());
                        continue;
                    }
                    newProjections.add(projection);
                }
                if (literals.size() > 0) {
                    plan = new Eval(project.source(), project.child(), literals);
                    plan = new Project(project.source(), plan, newProjections);
                } else {
                    plan = project;
                }
            } else {
                plan = (LogicalPlan)plan.transformExpressionsOnlyUp(FieldAttribute.class, f -> stats.exists(f.qualifiedName()) ? f : Literal.of((Expression)f, null));
            }
            return plan;
        }
    }

    static abstract class ParameterizedOptimizerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        ParameterizedOptimizerRule() {
        }

        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return (LogicalPlan)plan.transformUp(this.typeToken(), t -> this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);
    }
}

