/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Location;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.EsField;

public final class PlanStreamInput
extends NamedWriteableAwareStreamInput {
    private static final Supplier<LongFunction<NameId>> DEFAULT_NAME_ID_FUNC = NameIdMapper::new;
    private final PlanNameRegistry registry;
    private final LongFunction<NameId> nameIdFunction;
    private final EsqlConfiguration configuration;

    public PlanStreamInput(StreamInput streamInput, PlanNameRegistry registry, NamedWriteableRegistry namedWriteableRegistry, EsqlConfiguration configuration) {
        super(streamInput, namedWriteableRegistry);
        this.registry = registry;
        this.configuration = configuration;
        this.nameIdFunction = DEFAULT_NAME_ID_FUNC.get();
    }

    NameId nameIdFromLongValue(long value) {
        return this.nameIdFunction.apply(value);
    }

    DataType dataTypeFromTypeName(String typeName) throws IOException {
        DataType dataType = typeName.equalsIgnoreCase(EsQueryExec.DOC_DATA_TYPE.name()) ? EsQueryExec.DOC_DATA_TYPE : EsqlDataTypes.fromTypeName(typeName);
        if (dataType == null) {
            throw new IOException("Unknown DataType for type name: " + typeName);
        }
        return dataType;
    }

    public LogicalPlan readLogicalPlanNode() throws IOException {
        return this.readNamed(LogicalPlan.class);
    }

    public PhysicalPlan readPhysicalPlanNode() throws IOException {
        return this.readNamed(PhysicalPlan.class);
    }

    public Source readSource() throws IOException {
        boolean hasSource = this.readBoolean();
        if (hasSource) {
            int line = this.readInt();
            int column = this.readInt();
            int length = this.readInt();
            int charPositionInLine = column - 1;
            return new Source(new Location(line, charPositionInLine), PlanStreamInput.sourceText(this.configuration.query(), line, column, length));
        }
        return Source.EMPTY;
    }

    private static String sourceText(String query, int line, int column, int length) {
        if (line <= 0 || column <= 0 || query.isEmpty()) {
            return "";
        }
        int offset = PlanStreamInput.textOffset(query, line, column);
        if (offset + length > query.length()) {
            throw new EsqlIllegalArgumentException("location [@" + line + ":" + column + "] and length [" + length + "] overrun query size [" + query.length() + "]");
        }
        return query.substring(offset, offset + length);
    }

    private static int textOffset(String query, int line, int column) {
        int offset = 0;
        if (line > 1) {
            String[] lines = query.split("\n");
            if (line > lines.length) {
                throw new EsqlIllegalArgumentException("line location [" + line + "] higher than max [" + lines.length + "] in query [" + query + "]");
            }
            for (int i = 0; i < line - 1; ++i) {
                offset += lines[i].length() + 1;
            }
        }
        return offset += column - 1;
    }

    public Expression readExpression() throws IOException {
        return this.readNamed(Expression.class);
    }

    public NamedExpression readNamedExpression() throws IOException {
        return this.readNamed(NamedExpression.class);
    }

    public Attribute readAttribute() throws IOException {
        return this.readNamed(Attribute.class);
    }

    public EsField readEsFieldNamed() throws IOException {
        return this.readNamed(EsField.class);
    }

    public <T> T readNamed(Class<T> type) throws IOException {
        String name = this.readString();
        PlanNameRegistry.PlanReader<T> reader = this.registry.getReader(type, name);
        if (reader instanceof PlanNameRegistry.PlanNamedReader) {
            PlanNameRegistry.PlanNamedReader namedReader = (PlanNameRegistry.PlanNamedReader)reader;
            return (T)namedReader.read(this, name);
        }
        return reader.read(this);
    }

    public <T> T readOptionalNamed(Class<T> type) throws IOException {
        if (this.readBoolean()) {
            T t = this.readNamed(type);
            if (t == null) {
                PlanStreamInput.throwOnNullOptionalRead(type);
            }
            return t;
        }
        return null;
    }

    public <T> T readOptionalWithReader(PlanNameRegistry.PlanReader<T> reader) throws IOException {
        if (this.readBoolean()) {
            T t = reader.read(this);
            if (t == null) {
                PlanStreamInput.throwOnNullOptionalRead(reader);
            }
            return t;
        }
        return null;
    }

    public AttributeSet readAttributeSet(Writeable.Reader<Attribute> reader) throws IOException {
        int count = this.readArraySize();
        if (count == 0) {
            return new AttributeSet();
        }
        HashSet<Attribute> builder = new HashSet<Attribute>();
        for (int i = 0; i < count; ++i) {
            builder.add((Attribute)reader.read((StreamInput)this));
        }
        return new AttributeSet(builder);
    }

    public EsqlConfiguration configuration() throws IOException {
        return this.configuration;
    }

    static void throwOnNullOptionalRead(Class<?> type) throws IOException {
        IOException e = new IOException("read optional named returned null which is not allowed, type:" + type);
        assert (false) : e;
        throw e;
    }

    static void throwOnNullOptionalRead(PlanNameRegistry.PlanReader<?> reader) throws IOException {
        IOException e = new IOException("read optional named returned null which is not allowed, reader:" + reader);
        assert (false) : e;
        throw e;
    }

    static final class NameIdMapper
    implements LongFunction<NameId> {
        final Map<Long, NameId> seen = new HashMap<Long, NameId>();

        NameIdMapper() {
        }

        @Override
        public NameId apply(long streamNameId) {
            return this.seen.computeIfAbsent(streamNameId, k -> new NameId());
        }
    }
}

