/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.time.DateTimeException;
import java.time.temporal.TemporalAmount;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.ql.tree.Source;

public final class SubDatetimesEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator datetime;
    private final TemporalAmount temporalAmount;
    private final DriverContext driverContext;

    public SubDatetimesEvaluator(Source source, EvalOperator.ExpressionEvaluator datetime, TemporalAmount temporalAmount, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.datetime = datetime;
        this.temporalAmount = temporalAmount;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref datetimeRef = this.datetime.eval(page);){
            if (datetimeRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            LongBlock datetimeBlock = (LongBlock)datetimeRef.block();
            LongVector datetimeVector = datetimeBlock.asVector();
            if (datetimeVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), datetimeBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), datetimeVector));
            return ref;
        }
    }

    public LongBlock eval(int positionCount, LongBlock datetimeBlock) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (datetimeBlock.isNull(p) || datetimeBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(Sub.processDatetimes(datetimeBlock.getLong(datetimeBlock.getFirstValueIndex(p)), this.temporalAmount));
                    continue;
                }
                catch (ArithmeticException | DateTimeException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector datetimeVector) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(Sub.processDatetimes(datetimeVector.getLong(p), this.temporalAmount));
                    continue;
                }
                catch (ArithmeticException | DateTimeException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "SubDatetimesEvaluator[datetime=" + this.datetime + ", temporalAmount=" + this.temporalAmount + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.datetime);
    }
}

