/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.ql.tree.Source;

public final class NegIntsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;

    public NegIntsEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref vRef = this.v.eval(page);){
            if (vRef.block().areAllValuesNull()) {
                Block.Ref ref = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                return ref;
            }
            IntBlock vBlock = (IntBlock)vRef.block();
            IntVector vVector = vBlock.asVector();
            if (vVector == null) {
                Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vBlock));
                return ref;
            }
            Block.Ref ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), vVector));
            return ref;
        }
    }

    public IntBlock eval(int positionCount, IntBlock vBlock) {
        try (IntBlock.Builder result = IntBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p) || vBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendInt(Neg.processInts(vBlock.getInt(vBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntVector vVector) {
        try (IntBlock.Builder result = IntBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendInt(Neg.processInts(vVector.getInt(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "NegIntsEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }
}

