/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.time.Duration;
import java.time.Period;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.ExceptionUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.NegDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.NegIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.NegLongsEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Neg
extends UnaryScalarFunction
implements EvaluatorMapper {
    private final Warnings warnings;

    public Neg(Source source, Expression field) {
        super(source, field);
        this.warnings = new Warnings(source);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        DataType type = this.dataType();
        if (type.isNumeric()) {
            EvalOperator.ExpressionEvaluator.Factory f = toEvaluator.apply(this.field());
            EvalOperator.ExpressionEvaluator.Factory supplier = null;
            if (type == DataTypes.INTEGER) {
                supplier = dvrCtx -> new NegIntsEvaluator(this.source(), f.get(dvrCtx), dvrCtx);
            } else if (type == DataTypes.LONG) {
                supplier = dvrCtx -> new NegLongsEvaluator(this.source(), f.get(dvrCtx), dvrCtx);
            } else if (type == DataTypes.DOUBLE) {
                supplier = dvrCtx -> new NegDoublesEvaluator(f.get(dvrCtx), dvrCtx);
            }
            if (supplier != null) {
                return supplier;
            }
        } else if (EsqlDataTypes.isTemporalAmount(type)) {
            return toEvaluator.apply(this.field());
        }
        throw new EsqlIllegalArgumentException("arithmetic negation operator with unsupported data type [" + type + "]");
    }

    @Override
    public final Object fold() {
        DataType dataType = this.field().dataType();
        if (dataType == EsqlDataTypes.DATE_PERIOD) {
            Period fieldValue = (Period)this.field().fold();
            try {
                return fieldValue.negated();
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (dataType == EsqlDataTypes.TIME_DURATION) {
            Duration fieldValue = (Duration)this.field().fold();
            try {
                return fieldValue.negated();
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        return EvaluatorMapper.super.fold();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() || EsqlDataTypes.isTemporalAmount(dt), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric", "date_period", "time_duration"});
    }

    protected NodeInfo<Neg> info() {
        return NodeInfo.create((Node)this, Neg::new, (Object)this.field());
    }

    public Neg replaceChildren(List<Expression> newChildren) {
        return new Neg(this.source(), newChildren.get(0));
    }

    static int processInts(int v) {
        return Math.negateExact(v);
    }

    static long processLongs(long v) {
        return Math.negateExact(v);
    }

    static double processDoubles(double v) {
        return -v;
    }
}

