/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModUnsignedLongsEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Mod
extends EsqlArithmeticOperation {
    public Mod(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.MOD, ModIntsEvaluator::new, ModLongsEvaluator::new, ModUnsignedLongsEvaluator::new, (s, l, r, dvrCtx) -> new ModDoublesEvaluator(l, r, dvrCtx));
    }

    protected NodeInfo<Mod> info() {
        return NodeInfo.create((Node)this, Mod::new, (Object)this.left(), (Object)this.right());
    }

    protected Mod replaceChildren(Expression left, Expression right) {
        return new Mod(this.source(), left, right);
    }

    static int processInts(int lhs, int rhs) {
        return lhs % rhs;
    }

    static long processLongs(long lhs, long rhs) {
        return lhs % rhs;
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.asLongUnsigned((long)Long.remainderUnsigned(NumericUtils.asLongUnsigned((long)lhs), NumericUtils.asLongUnsigned((long)rhs)));
    }

    static double processDoubles(double lhs, double rhs) {
        return lhs % rhs;
    }
}

