/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.ql.tree.Source;

public final class DivUnsignedLongsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator rhs;
    private final DriverContext driverContext;

    public DivUnsignedLongsEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator rhs, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref lhsRef = this.lhs.eval(page);){
            Block.Ref ref;
            block26: {
                LongVector rhsVector;
                LongVector lhsVector;
                Block.Ref rhsRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        LongBlock rhsBlock;
                        LongBlock lhsBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (lhsRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        lhsBlock = (LongBlock)lhsRef.block();
                                        rhsRef = this.rhs.eval(page);
                                        try {
                                            if (!rhsRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (rhsRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (rhsRef != null) {
                                                try {
                                                    rhsRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        rhsRef.close();
                                    }
                                    return ref4;
                                }
                                rhsBlock = (LongBlock)rhsRef.block();
                                lhsVector = lhsBlock.asVector();
                                if (lhsVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), lhsBlock, rhsBlock));
                                if (rhsRef == null) break block23;
                                rhsRef.close();
                            }
                            return ref3;
                        }
                        rhsVector = rhsBlock.asVector();
                        if (rhsVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), lhsBlock, rhsBlock));
                        if (rhsRef == null) break block25;
                        rhsRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), lhsVector, rhsVector));
                if (rhsRef == null) break block26;
                rhsRef.close();
            }
            return ref;
        }
    }

    public LongBlock eval(int positionCount, LongBlock lhsBlock, LongBlock rhsBlock) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (lhsBlock.isNull(p) || lhsBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.isNull(p) || rhsBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendLong(Div.processUnsignedLongs(lhsBlock.getLong(lhsBlock.getFirstValueIndex(p)), rhsBlock.getLong(rhsBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector lhsVector, LongVector rhsVector) {
        try (LongBlock.Builder result = LongBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendLong(Div.processUnsignedLongs(lhsVector.getLong(p), rhsVector.getLong(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DivUnsignedLongsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, this.rhs});
    }
}

