/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DivUnsignedLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Div
extends EsqlArithmeticOperation
implements BinaryComparisonInversible {
    private DataType type;

    public Div(Source source, Expression left, Expression right) {
        this(source, left, right, null);
    }

    public Div(Source source, Expression left, Expression right, DataType type) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.DIV, DivIntsEvaluator::new, DivLongsEvaluator::new, DivUnsignedLongsEvaluator::new, (s, l, r, dvrCtx) -> new DivDoublesEvaluator(l, r, dvrCtx));
        this.type = type;
    }

    @Override
    public DataType dataType() {
        if (this.type == null) {
            this.type = super.dataType();
        }
        return this.type;
    }

    protected NodeInfo<Div> info() {
        return NodeInfo.create((Node)this, Div::new, (Object)this.left(), (Object)this.right(), (Object)this.type);
    }

    protected Div replaceChildren(Expression newLeft, Expression newRight) {
        return new Div(this.source(), newLeft, newRight, this.type);
    }

    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Mul::new;
    }

    static int processInts(int lhs, int rhs) {
        return lhs / rhs;
    }

    static long processLongs(long lhs, long rhs) {
        return lhs / rhs;
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.asLongUnsigned((long)Long.divideUnsigned(NumericUtils.asLongUnsigned((long)lhs), NumericUtils.asLongUnsigned((long)rhs)));
    }

    static double processDoubles(double lhs, double rhs) {
        return lhs / rhs;
    }
}

