/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Substring;

public final class SubstringNoLengthEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator start;
    private final DriverContext driverContext;

    public SubstringNoLengthEvaluator(EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator start, DriverContext driverContext) {
        this.str = str;
        this.start = start;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref strRef = this.str.eval(page);){
            Block.Ref ref;
            block26: {
                IntVector startVector;
                BytesRefVector strVector;
                Block.Ref startRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        IntBlock startBlock;
                        BytesRefBlock strBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (strRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        strBlock = (BytesRefBlock)strRef.block();
                                        startRef = this.start.eval(page);
                                        try {
                                            if (!startRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (startRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (startRef != null) {
                                                try {
                                                    startRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        startRef.close();
                                    }
                                    return ref4;
                                }
                                startBlock = (IntBlock)startRef.block();
                                strVector = strBlock.asVector();
                                if (strVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, startBlock));
                                if (startRef == null) break block23;
                                startRef.close();
                            }
                            return ref3;
                        }
                        startVector = startBlock.asVector();
                        if (startVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, startBlock));
                        if (startRef == null) break block25;
                        startRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strVector, startVector).asBlock());
                if (startRef == null) break block26;
                startRef.close();
            }
            return ref;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, IntBlock startBlock) {
        try (BytesRefBlock.Builder result = BytesRefBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p) || strBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (startBlock.isNull(p) || startBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(Substring.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), startBlock.getInt(startBlock.getFirstValueIndex(p))));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector strVector, IntVector startVector) {
        try (BytesRefVector.Builder result = BytesRefVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(Substring.process(strVector.getBytesRef(p, strScratch), startVector.getInt(p)));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "SubstringNoLengthEvaluator[str=" + this.str + ", start=" + this.start + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.start});
    }
}

