/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SubstringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SubstringNoLengthEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Substring
extends ScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    private final Expression str;
    private final Expression start;
    private final Expression length;

    public Substring(Source source, Expression str, Expression start, Expression length) {
        super(source, length == null ? Arrays.asList(str, start) : Arrays.asList(str, start, length));
        this.str = str;
        this.start = start;
        this.length = length;
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isInteger((Expression)this.start, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.length == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isInteger((Expression)this.length, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
    }

    public boolean foldable() {
        return this.str.foldable() && this.start.foldable() && (this.length == null || this.length.foldable());
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    static BytesRef process(BytesRef str, int start) {
        if (str.length == 0) {
            return null;
        }
        int codePointCount = UnicodeUtil.codePointCount((BytesRef)str);
        int indexStart = Substring.indexStart(codePointCount, start);
        return new BytesRef((CharSequence)str.utf8ToString().substring(indexStart));
    }

    static BytesRef process(BytesRef str, int start, int length) {
        if (str.length == 0) {
            return null;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length parameter cannot be negative, found [" + length + "]");
        }
        int codePointCount = UnicodeUtil.codePointCount((BytesRef)str);
        int indexStart = Substring.indexStart(codePointCount, start);
        int indexEnd = Math.min(codePointCount, indexStart + length);
        String s = str.utf8ToString();
        return new BytesRef((CharSequence)s.substring(s.offsetByCodePoints(0, indexStart), s.offsetByCodePoints(0, indexEnd)));
    }

    private static int indexStart(int codePointCount, int start) {
        int indexStart = start > 0 ? start - 1 : (start < 0 ? codePointCount + start : start);
        return Math.min(Math.max(0, indexStart), codePointCount);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Substring(this.source(), newChildren.get(0), newChildren.get(1), this.length == null ? null : newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Substring::new, (Object)this.str, (Object)this.start, (Object)this.length);
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strSupplier = toEvaluator.apply(this.str);
        EvalOperator.ExpressionEvaluator.Factory startSupplier = toEvaluator.apply(this.start);
        if (this.length == null) {
            return dvrCtx -> new SubstringNoLengthEvaluator(strSupplier.get(dvrCtx), startSupplier.get(dvrCtx), dvrCtx);
        }
        EvalOperator.ExpressionEvaluator.Factory lengthSupplier = toEvaluator.apply(this.length);
        return dvrCtx -> new SubstringEvaluator(strSupplier.get(dvrCtx), startSupplier.get(dvrCtx), lengthSupplier.get(dvrCtx), dvrCtx);
    }
}

