/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.StartsWith;

public final class StartsWithEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator prefix;
    private final DriverContext driverContext;

    public StartsWithEvaluator(EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator prefix, DriverContext driverContext) {
        this.str = str;
        this.prefix = prefix;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref strRef = this.str.eval(page);){
            Block.Ref ref;
            block26: {
                BytesRefVector prefixVector;
                BytesRefVector strVector;
                Block.Ref prefixRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        BytesRefBlock prefixBlock;
                        BytesRefBlock strBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (strRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        strBlock = (BytesRefBlock)strRef.block();
                                        prefixRef = this.prefix.eval(page);
                                        try {
                                            if (!prefixRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (prefixRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (prefixRef != null) {
                                                try {
                                                    prefixRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        prefixRef.close();
                                    }
                                    return ref4;
                                }
                                prefixBlock = (BytesRefBlock)prefixRef.block();
                                strVector = strBlock.asVector();
                                if (strVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, prefixBlock));
                                if (prefixRef == null) break block23;
                                prefixRef.close();
                            }
                            return ref3;
                        }
                        prefixVector = prefixBlock.asVector();
                        if (prefixVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, prefixBlock));
                        if (prefixRef == null) break block25;
                        prefixRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strVector, prefixVector).asBlock());
                if (prefixRef == null) break block26;
                prefixRef.close();
            }
            return ref;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock prefixBlock) {
        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            BytesRef prefixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p) || strBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (prefixBlock.isNull(p) || prefixBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(StartsWith.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), prefixBlock.getBytesRef(prefixBlock.getFirstValueIndex(p), prefixScratch)));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector strVector, BytesRefVector prefixVector) {
        try (BooleanVector.Builder result = BooleanVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            BytesRef prefixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(StartsWith.process(strVector.getBytesRef(p, strScratch), prefixVector.getBytesRef(p, prefixScratch)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "StartsWithEvaluator[str=" + this.str + ", prefix=" + this.prefix + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.prefix});
    }
}

