/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Split;

public final class SplitVariableEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator delim;
    private final BytesRef scratch;
    private final DriverContext driverContext;

    public SplitVariableEvaluator(EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator delim, BytesRef scratch, DriverContext driverContext) {
        this.str = str;
        this.delim = delim;
        this.scratch = scratch;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref strRef = this.str.eval(page);){
            Block.Ref ref;
            block26: {
                BytesRefVector delimVector;
                BytesRefVector strVector;
                Block.Ref delimRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        BytesRefBlock delimBlock;
                        BytesRefBlock strBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (strRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        strBlock = (BytesRefBlock)strRef.block();
                                        delimRef = this.delim.eval(page);
                                        try {
                                            if (!delimRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (delimRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (delimRef != null) {
                                                try {
                                                    delimRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        delimRef.close();
                                    }
                                    return ref4;
                                }
                                delimBlock = (BytesRefBlock)delimRef.block();
                                strVector = strBlock.asVector();
                                if (strVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, delimBlock));
                                if (delimRef == null) break block23;
                                delimRef.close();
                            }
                            return ref3;
                        }
                        delimVector = delimBlock.asVector();
                        if (delimVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, delimBlock));
                        if (delimRef == null) break block25;
                        delimRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strVector, delimVector));
                if (delimRef == null) break block26;
                delimRef.close();
            }
            return ref;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock delimBlock) {
        try (BytesRefBlock.Builder result = BytesRefBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            BytesRef delimScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p) || strBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (delimBlock.isNull(p) || delimBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                Split.process(result, strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), delimBlock.getBytesRef(delimBlock.getFirstValueIndex(p), delimScratch), this.scratch);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector, BytesRefVector delimVector) {
        try (BytesRefBlock.Builder result = BytesRefBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            BytesRef delimScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                Split.process(result, strVector.getBytesRef(p, strScratch), delimVector.getBytesRef(p, delimScratch), this.scratch);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "SplitVariableEvaluator[str=" + this.str + ", delim=" + this.delim + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.delim});
    }
}

