/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Right;

public final class RightEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final BytesRef out;
    private final UnicodeUtil.UTF8CodePoint cp;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator length;
    private final DriverContext driverContext;

    public RightEvaluator(BytesRef out, UnicodeUtil.UTF8CodePoint cp, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator length, DriverContext driverContext) {
        this.out = out;
        this.cp = cp;
        this.str = str;
        this.length = length;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref strRef = this.str.eval(page);){
            Block.Ref ref;
            block26: {
                IntVector lengthVector;
                BytesRefVector strVector;
                Block.Ref lengthRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        IntBlock lengthBlock;
                        BytesRefBlock strBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (strRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        strBlock = (BytesRefBlock)strRef.block();
                                        lengthRef = this.length.eval(page);
                                        try {
                                            if (!lengthRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (lengthRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (lengthRef != null) {
                                                try {
                                                    lengthRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        lengthRef.close();
                                    }
                                    return ref4;
                                }
                                lengthBlock = (IntBlock)lengthRef.block();
                                strVector = strBlock.asVector();
                                if (strVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, lengthBlock));
                                if (lengthRef == null) break block23;
                                lengthRef.close();
                            }
                            return ref3;
                        }
                        lengthVector = lengthBlock.asVector();
                        if (lengthVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, lengthBlock));
                        if (lengthRef == null) break block25;
                        lengthRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strVector, lengthVector).asBlock());
                if (lengthRef == null) break block26;
                lengthRef.close();
            }
            return ref;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, IntBlock lengthBlock) {
        try (BytesRefBlock.Builder result = BytesRefBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p) || strBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (lengthBlock.isNull(p) || lengthBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(Right.process(this.out, this.cp, strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), lengthBlock.getInt(lengthBlock.getFirstValueIndex(p))));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector strVector, IntVector lengthVector) {
        try (BytesRefVector.Builder result = BytesRefVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(Right.process(this.out, this.cp, strVector.getBytesRef(p, strScratch), lengthVector.getInt(p)));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "RightEvaluator[str=" + this.str + ", length=" + this.length + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.length});
    }
}

