/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWith;

public final class EndsWithEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator suffix;
    private final DriverContext driverContext;

    public EndsWithEvaluator(EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator suffix, DriverContext driverContext) {
        this.str = str;
        this.suffix = suffix;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref strRef = this.str.eval(page);){
            Block.Ref ref;
            block26: {
                BytesRefVector suffixVector;
                BytesRefVector strVector;
                Block.Ref suffixRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        BytesRefBlock suffixBlock;
                        BytesRefBlock strBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (strRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        strBlock = (BytesRefBlock)strRef.block();
                                        suffixRef = this.suffix.eval(page);
                                        try {
                                            if (!suffixRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (suffixRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (suffixRef != null) {
                                                try {
                                                    suffixRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        suffixRef.close();
                                    }
                                    return ref4;
                                }
                                suffixBlock = (BytesRefBlock)suffixRef.block();
                                strVector = strBlock.asVector();
                                if (strVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, suffixBlock));
                                if (suffixRef == null) break block23;
                                suffixRef.close();
                            }
                            return ref3;
                        }
                        suffixVector = suffixBlock.asVector();
                        if (suffixVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strBlock, suffixBlock));
                        if (suffixRef == null) break block25;
                        suffixRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), strVector, suffixVector).asBlock());
                if (suffixRef == null) break block26;
                suffixRef.close();
            }
            return ref;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock suffixBlock) {
        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            BytesRef suffixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p) || strBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (suffixBlock.isNull(p) || suffixBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(EndsWith.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), suffixBlock.getBytesRef(suffixBlock.getFirstValueIndex(p), suffixScratch)));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector strVector, BytesRefVector suffixVector) {
        try (BooleanVector.Builder result = BooleanVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            BytesRef strScratch = new BytesRef();
            BytesRef suffixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(EndsWith.process(strVector.getBytesRef(p, strScratch), suffixVector.getBytesRef(p, suffixScratch)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "EndsWithEvaluator[str=" + this.str + ", suffix=" + this.suffix + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.suffix});
    }
}

